/*
 * Decompiled with CFR 0.152.
 */
package obp.if2.external;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import obp.if2.If2Visitor;
import obp.if2.NamedElement;
import obp.if2.data.TypedElement;
import obp.if2.data.types.PredefinedType;

public class Function
implements NamedElement,
TypedElement {
    private final List<PredefinedType> parametersTypesList = new ArrayList<PredefinedType>();
    private String name;
    private PredefinedType type;

    public List<PredefinedType> getParametersTypesList() {
        return Collections.unmodifiableList(this.parametersTypesList);
    }

    public int getParametersTypesCount() {
        return this.parametersTypesList.size();
    }

    public PredefinedType getParametersTypes(int index) {
        if (index < 0 || index >= this.getParametersTypesCount()) {
            return null;
        }
        return this.parametersTypesList.get(index);
    }

    public void addParametersTypes(PredefinedType newValue) {
        this.addParametersTypes(this.getParametersTypesCount(), newValue);
    }

    public void addParametersTypes(int index, PredefinedType newValue) {
        this.parametersTypesList.add(index, newValue);
    }

    public PredefinedType setParametersTypes(int index, PredefinedType newValue) {
        return this.parametersTypesList.set(index, newValue);
    }

    public void addAllParametersTypes(Collection<PredefinedType> toAddList) {
        for (PredefinedType newValue : toAddList) {
            this.addParametersTypes(this.getParametersTypesCount(), newValue);
        }
    }

    public void removeParametersTypes(PredefinedType value) {
        int index = this.parametersTypesList.indexOf(value);
        if (index >= 0) {
            this.removeParametersTypes(index);
        }
    }

    public void removeParametersTypes(int index) {
        this.parametersTypesList.remove(index);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newValue) {
        if (this.name == null ? newValue != null : !this.name.equals(newValue)) {
            this.name = newValue;
        }
    }

    @Override
    public PredefinedType getType() {
        return this.type;
    }

    @Override
    public void setType(PredefinedType newValue) {
        if (this.type == null ? newValue != null : !this.type.equals(newValue)) {
            this.type = newValue;
        }
    }

    @Override
    public void accept(If2Visitor visitor) {
        visitor.visitFunction(this);
    }
}

