/*
 * Decompiled with CFR 0.152.
 */
package obp.if2.data.types.complex;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import obp.if2.If2Visitor;
import obp.if2.NamedElement;
import obp.if2.data.Type;
import obp.if2.data.types.DeclaredType;
import obp.if2.data.types.complex.CompositeType;
import obp.if2.structure.Entity;

public abstract class DerivedType
implements Type,
NamedElement {
    private DerivedType otherType;
    private final List<DeclaredType> referenceDeclarationList = new ArrayList<DeclaredType>();
    private Entity entity;
    private CompositeType parentType;
    private String name;

    public DerivedType getOtherType() {
        return this.otherType;
    }

    public void setOtherType(DerivedType newValue) {
        if (this.otherType != newValue) {
            this.otherType = newValue;
        }
    }

    public List<DeclaredType> getReferenceDeclarationList() {
        return Collections.unmodifiableList(this.referenceDeclarationList);
    }

    public int getReferenceDeclarationCount() {
        return this.referenceDeclarationList.size();
    }

    public DeclaredType getReferenceDeclaration(int index) {
        if (index < 0 || index >= this.getReferenceDeclarationCount()) {
            return null;
        }
        return this.referenceDeclarationList.get(index);
    }

    public void addReferenceDeclaration(DeclaredType newValue) {
        this.addReferenceDeclaration(this.getReferenceDeclarationCount(), newValue);
    }

    public void addReferenceDeclaration(int index, DeclaredType newValue) {
        this.referenceDeclarationList.add(index, newValue);
    }

    public DeclaredType setReferenceDeclaration(int index, DeclaredType newValue) {
        return this.referenceDeclarationList.set(index, newValue);
    }

    public void addAllReferenceDeclaration(Collection<DeclaredType> toAddList) {
        for (DeclaredType newValue : toAddList) {
            this.addReferenceDeclaration(this.getReferenceDeclarationCount(), newValue);
        }
    }

    public void removeReferenceDeclaration(DeclaredType value) {
        int index = this.referenceDeclarationList.indexOf(value);
        if (index >= 0) {
            this.removeReferenceDeclaration(index);
        }
    }

    public void removeReferenceDeclaration(int index) {
        this.referenceDeclarationList.remove(index);
    }

    public void addReferenceDeclarationAndOpposite(DeclaredType newValue) {
        this.addReferenceDeclaration(newValue);
        if (newValue != null) {
            newValue.setType(this);
        }
    }

    public void addAllReferenceDeclarationAndOpposite(Collection<DeclaredType> toAddList) {
        for (DeclaredType newValue : toAddList) {
            this.addReferenceDeclarationAndOpposite(this.getReferenceDeclarationCount(), newValue);
        }
    }

    public void addReferenceDeclarationAndOpposite(int index, DeclaredType newValue) {
        this.addReferenceDeclaration(index, newValue);
        if (newValue != null) {
            newValue.setType(this);
        }
    }

    public DeclaredType setReferenceDeclarationAndOpposite(int index, DeclaredType newValue) {
        DeclaredType oldValue = this.referenceDeclarationList.set(index, newValue);
        if (newValue != null) {
            newValue.setType(this);
        }
        return oldValue;
    }

    public void removeReferenceDeclarationAndOpposite(DeclaredType removed) {
        this.removeReferenceDeclaration(removed);
        if (removed != null) {
            removed.setType(null);
        }
    }

    public void removeReferenceDeclarationAndOpposite(int index) {
        DeclaredType removed = this.referenceDeclarationList.get(index);
        this.removeReferenceDeclaration(index);
        if (removed != null) {
            removed.setType(null);
        }
    }

    public Entity getEntity() {
        return this.entity;
    }

    public void setEntity(Entity newValue) {
        if (this.entity == null ? newValue != null : !this.entity.equals(newValue)) {
            this.entity = newValue;
        }
    }

    public CompositeType getParentType() {
        return this.parentType;
    }

    public void setParentType(CompositeType newValue) {
        if (this.parentType == null ? newValue != null : !this.parentType.equals(newValue)) {
            this.parentType = newValue;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newValue) {
        if (this.name == null ? newValue != null : !this.name.equals(newValue)) {
            this.name = newValue;
        }
    }

    @Override
    public abstract void accept(If2Visitor var1);
}

