/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import obp.fiacre.model.AnyPattern;
import obp.fiacre.model.ArgumentVariable;
import obp.fiacre.model.Array;
import obp.fiacre.model.ArrayElem;
import obp.fiacre.model.ArrayPattern;
import obp.fiacre.model.BinExp;
import obp.fiacre.model.BinOp;
import obp.fiacre.model.BoolLiteral;
import obp.fiacre.model.BoolType;
import obp.fiacre.model.CaseStmt;
import obp.fiacre.model.Channel;
import obp.fiacre.model.Commented;
import obp.fiacre.model.ConstantDecl;
import obp.fiacre.model.ConstantRef;
import obp.fiacre.model.Constr;
import obp.fiacre.model.ConstrExp;
import obp.fiacre.model.ConstrPattern;
import obp.fiacre.model.DeterministicAssignment;
import obp.fiacre.model.Emission;
import obp.fiacre.model.Exp;
import obp.fiacre.model.Field;
import obp.fiacre.model.FieldPattern;
import obp.fiacre.model.FunctionDecl;
import obp.fiacre.model.IfStmt;
import obp.fiacre.model.InlineArray;
import obp.fiacre.model.InlineQueue;
import obp.fiacre.model.InlineRecord;
import obp.fiacre.model.IntType;
import obp.fiacre.model.Interval;
import obp.fiacre.model.Literal;
import obp.fiacre.model.LocalPortDecl;
import obp.fiacre.model.LocalVariable;
import obp.fiacre.model.NatLiteral;
import obp.fiacre.model.NatType;
import obp.fiacre.model.NullStmt;
import obp.fiacre.model.ParamPortDecl;
import obp.fiacre.model.Pattern;
import obp.fiacre.model.PortDecl;
import obp.fiacre.model.ProcessDecl;
import obp.fiacre.model.Profile;
import obp.fiacre.model.Queue;
import obp.fiacre.model.Reception;
import obp.fiacre.model.Record;
import obp.fiacre.model.RecordElem;
import obp.fiacre.model.RefArg;
import obp.fiacre.model.ReturnStmt;
import obp.fiacre.model.Rule;
import obp.fiacre.model.Select;
import obp.fiacre.model.Seq;
import obp.fiacre.model.SingleAssignment;
import obp.fiacre.model.State;
import obp.fiacre.model.Statement;
import obp.fiacre.model.To;
import obp.fiacre.model.Transition;
import obp.fiacre.model.Type;
import obp.fiacre.model.TypeDecl;
import obp.fiacre.model.TypeId;
import obp.fiacre.model.UnExp;
import obp.fiacre.model.UnOp;
import obp.fiacre.model.Union;
import obp.fiacre.model.ValuedField;
import obp.fiacre.model.VarRef;
import obp.fiacre.model.Variable;
import obp.fiacre.model.WhileStmt;
import obp.fiacre.util.FiacreInitialValue;

public class FiacreBuilder {
    public BoolType boolType() {
        return new BoolType();
    }

    public NatType natType() {
        return new NatType();
    }

    public IntType intType() {
        return new IntType();
    }

    public Interval interval(Exp min, Exp max) {
        Interval intv = new Interval();
        intv.setMini(min);
        intv.setMaxi(max);
        return intv;
    }

    public Queue queueType(Exp size, Type elementType) {
        Queue q = new Queue();
        q.setSize(size);
        q.setType(elementType);
        return q;
    }

    public Type unionType(String ... fields) {
        Union u = new Union();
        for (String s : fields) {
            u.addConstr(this.unionField(s, null));
        }
        return u;
    }

    public Type unionType(List<Constr> fields) {
        Union u = new Union();
        u.addAllConstr(fields);
        return u;
    }

    public Type unionType(Collection<Constr> fields) {
        Union u = new Union();
        for (Constr field : fields) {
            u.addConstr(field);
        }
        return u;
    }

    public Constr unionField(String name, Type type) {
        Constr constr = new Constr();
        constr.setName(name);
        constr.setType(type);
        return constr;
    }

    public Type arrayType(Exp size, Type elementType) {
        Array arr = new Array();
        arr.setSize(size);
        arr.setType(elementType);
        return arr;
    }

    public ConstantDecl constantDecl(String name, Type type, Exp exp) {
        ConstantDecl cons = new ConstantDecl();
        cons.setName(name);
        cons.setType(type);
        if (exp != null) {
            cons.setValue(exp);
        }
        return cons;
    }

    public ConstantRef constantRef(ConstantDecl con) {
        ConstantRef cr = new ConstantRef();
        cr.setDecl(con);
        return cr;
    }

    public ConstantRef constantRef(ConstantRef con) {
        ConstantRef cr = new ConstantRef();
        cr.setDecl(con.getDecl());
        return cr;
    }

    public Exp and(Exp e1, Exp e2) {
        return this.expression(BinOp.BAND, e1, e2);
    }

    public Exp or(Exp e1, Exp e2) {
        return this.expression(BinOp.BOR, e1, e2);
    }

    public Exp enqueue(Exp e1, Exp e2) {
        return this.expression(BinOp.ENQUEUE, e1, e2);
    }

    public Exp minus(Exp exp) {
        return this.expression(UnOp.UMINUS, exp);
    }

    public Exp dollar(Exp exp) {
        return this.expression(UnOp.UDOLLAR, exp);
    }

    public Exp not(Exp exp) {
        return this.expression(UnOp.UNOT, exp);
    }

    public Exp full(Exp exp) {
        return this.expression(UnOp.UFULL, exp);
    }

    public Exp notFull(Exp exp) {
        return this.not(this.full(exp));
    }

    public Exp empty(Exp exp) {
        return this.expression(UnOp.UEMPTY, exp);
    }

    public Exp notEmpty(Exp exp) {
        return this.not(this.empty(exp));
    }

    public Exp dequeue(Exp exp) {
        return this.expression(UnOp.DEQUEUE, exp);
    }

    public Exp first(Exp exp) {
        return this.expression(UnOp.FIRST, exp);
    }

    public Exp length(Exp exp) {
        return this.expression(UnOp.LENGTH, exp);
    }

    public ArgumentVariable argumentVariable(String name, Type type) {
        return this.argumentVariable(name, type, true, false, false);
    }

    public ArgumentVariable argumentVariable(String name, Type type, boolean isRead, boolean isWrite, boolean isRef) {
        ArgumentVariable arg = new ArgumentVariable();
        arg.setName(name);
        arg.setType(type);
        arg.setRead(isRead);
        arg.setWrite(isWrite);
        arg.setRef(isRef);
        return arg;
    }

    public Literal literal(boolean n) {
        BoolLiteral b = new BoolLiteral();
        b.setValue(n);
        return b;
    }

    public Literal literal(int n) {
        NatLiteral nat = new NatLiteral();
        nat.setValue(n);
        return nat;
    }

    public Exp expression(UnOp op, Exp e) {
        UnExp u = new UnExp();
        u.setUnop(op);
        u.setExp(e);
        return u;
    }

    public Exp expression(BinOp op, Exp lhs, Exp rhs) {
        BinExp u = new BinExp();
        u.setBinOp(op);
        u.setLeft(lhs);
        u.setRight(rhs);
        return u;
    }

    public Exp initialValue(Type type) {
        if (type == null) {
            return null;
        }
        FiacreInitialValue fIV = new FiacreInitialValue();
        type.accept(fIV);
        return fIV.getInitialValue();
    }

    public Statement assign(Pattern lhs, Exp rhs) {
        DeterministicAssignment assignment = new DeterministicAssignment();
        SingleAssignment singleAssignment = new SingleAssignment();
        singleAssignment.setLhs(lhs);
        singleAssignment.setRhs(rhs);
        assignment.addAssignment(singleAssignment);
        return assignment;
    }

    public Statement simpleDequeueStmt(VarRef queue) {
        return this.assign(queue, this.dequeue(queue));
    }

    public Emission emission(PortDecl port, Exp ... expressions) {
        return this.emission(port, Arrays.asList(expressions));
    }

    public Emission emission(PortDecl port, List<Exp> expressions) {
        Emission node = new Emission();
        node.setPort(port);
        for (Exp e : expressions) {
            node.addArg(e);
        }
        return node;
    }

    public Reception oneReception(PortDecl port, Pattern ... patterns) {
        return this.reception(port, Arrays.asList(patterns));
    }

    public Reception reception(PortDecl port, List<Pattern> patterns) {
        Reception reception = new Reception();
        reception.setPort(port);
        for (Pattern pattern : patterns) {
            reception.addPattern(pattern);
        }
        return reception;
    }

    public State state(String name, ProcessDecl process) {
        State state = new State();
        state.setName(name);
        process.addState(state);
        return state;
    }

    public Select select(Statement ... statements) {
        return this.select(Arrays.asList(statements));
    }

    public Select select(List<Statement> statements) {
        Select select = new Select();
        for (Statement statement : statements) {
            select.addStatement(statement);
        }
        return select;
    }

    public Seq seq(Statement ... statements) {
        return this.seq(Arrays.asList(statements));
    }

    public Seq seq(List<Statement> stmts) {
        Seq seq = new Seq();
        for (Statement s : stmts) {
            if (s instanceof Seq) {
                seq.addAllComment(s.getCommentList());
                seq.addAllStatement(((Seq)s).getStatementList());
                continue;
            }
            seq.addStatement(s);
        }
        return seq;
    }

    public To toStmt(State target) {
        To to = new To();
        to.setDest(target);
        return to;
    }

    public To loopOn(Transition parent) {
        To to = new To();
        to.setDest(parent.getFrom());
        return to;
    }

    public IfStmt ifStmt(Exp condition, Statement thenS, Statement elseS) {
        IfStmt ifStmt = new IfStmt();
        ifStmt.setCondition(condition);
        ifStmt.setThen(thenS);
        ifStmt.setElse(elseS);
        return ifStmt;
    }

    public WhileStmt whileStmt(Exp condition, Statement body) {
        WhileStmt stmt = new WhileStmt();
        stmt.setCondition(condition);
        stmt.setBody(body);
        return stmt;
    }

    public NullStmt nullStmt() {
        return new NullStmt();
    }

    public NullStmt commentedNullStmt(String comment) {
        NullStmt result = new NullStmt();
        result.addComment(comment);
        return result;
    }

    public CaseStmt onStmt(Exp condition) {
        CaseStmt result = new CaseStmt();
        result.setExp(condition);
        Rule rule = new Rule();
        rule.setLhs(this.literal(true));
        rule.setAction(this.nullStmt());
        result.addRule(rule);
        return result;
    }

    public CaseStmt onNotEmpty(VarRef fifo) {
        return this.onStmt(this.not(this.empty(fifo)));
    }

    public CaseStmt caseStmt(Exp exp, Rule rule) {
        CaseStmt stmt = new CaseStmt();
        stmt.setExp(exp);
        stmt.addRule(rule);
        return stmt;
    }

    public CaseStmt caseStmt(Exp exp, List<Rule> rules) {
        CaseStmt stmt = new CaseStmt();
        stmt.setExp(exp);
        stmt.addAllRule(rules);
        return stmt;
    }

    public Rule rule(Pattern pattern, Statement stmt) {
        Rule r = new Rule();
        r.setLhs(pattern);
        r.setAction(stmt);
        return r;
    }

    public ReturnStmt returnStmt(Exp exp) {
        ReturnStmt ret = new ReturnStmt();
        ret.setExpression(exp);
        return ret;
    }

    public FunctionDecl functionDecl(String name, ArgumentVariable[] args, Type returnType, LocalVariable[] vars, Statement body) {
        return this.functionDecl(name, Arrays.asList(args), returnType, Arrays.asList(vars), body);
    }

    public FunctionDecl functionDecl(String name, List<ArgumentVariable> args, Type returnType, List<LocalVariable> vars, Statement body) {
        FunctionDecl func = new FunctionDecl();
        func.setName(name);
        func.addAllArg(args);
        func.setReturnType(returnType);
        func.addAllVar(vars);
        func.setBody(body);
        return func;
    }

    public LocalPortDecl localPortDecl(String name, Channel chan) {
        LocalPortDecl lpd = new LocalPortDecl();
        lpd.setName(name);
        if (chan != null) {
            lpd.setChannel(chan);
        }
        return lpd;
    }

    public ParamPortDecl portDecl(String name, Channel chan, boolean isInput, boolean isOutput) {
        ParamPortDecl portDecl = new ParamPortDecl();
        portDecl.setName(name);
        portDecl.setChannel(chan);
        if (isInput) {
            portDecl.setIn(true);
        }
        if (isOutput) {
            portDecl.setOut(true);
        }
        return portDecl;
    }

    public ParamPortDecl portDecl(String name, Type type, boolean isInput, boolean isOutput) {
        ParamPortDecl portDecl = new ParamPortDecl();
        portDecl.setName(name);
        Profile profile = new Profile();
        if (type != null) {
            profile.addType(type);
        }
        portDecl.setChannel(profile);
        if (isInput) {
            portDecl.setIn(true);
        }
        if (isOutput) {
            portDecl.setOut(true);
        }
        return portDecl;
    }

    public ParamPortDecl portDecl(String name, Type type, boolean isInput) {
        return this.portDecl(name, type, isInput, !isInput);
    }

    public Field field(String name, Type type) {
        Field field = new Field();
        field.setName(name);
        field.setType(type);
        return field;
    }

    public Record record(Field ... fields) {
        return this.record(Arrays.asList(fields));
    }

    public Record record(List<Field> fields) {
        Record record = new Record();
        for (Field f : fields) {
            record.addField(f);
        }
        return record;
    }

    public Exp selectedExp(Exp record, String field) {
        RecordElem recordElem = new RecordElem();
        recordElem.setRecord(record);
        recordElem.setField(field);
        return recordElem;
    }

    public Exp indexedExp(Exp array, Exp id) {
        ArrayElem ex = new ArrayElem();
        ex.setArray(array);
        ex.setIndex(id);
        return ex;
    }

    public Pattern arrayPattern(Pattern arr, Exp id) {
        ArrayPattern aP = new ArrayPattern();
        aP.setArray(arr);
        aP.setIndex(id);
        return aP;
    }

    public Pattern fieldPattern(Pattern prefix, String field) {
        FieldPattern pattern = new FieldPattern();
        pattern.setRecord(prefix);
        pattern.setField(field);
        return pattern;
    }

    public InlineArray literalArray(List<Exp> exps) {
        InlineArray exp = new InlineArray();
        if (exps == null) {
            return exp;
        }
        for (Exp e : exps) {
            exp.addElem(e);
        }
        return exp;
    }

    public InlineQueue literalQueue(List<Exp> exps) {
        InlineQueue exp = new InlineQueue();
        if (exps == null) {
            return exp;
        }
        for (Exp e : exps) {
            exp.addElem(e);
        }
        return exp;
    }

    public InlineRecord literal(List<ValuedField> fieldLiterals) {
        InlineRecord exp = new InlineRecord();
        if (fieldLiterals == null) {
            return exp;
        }
        for (ValuedField vF : fieldLiterals) {
            exp.addValue(vF);
        }
        return exp;
    }

    public ConstrExp literal(String name, Exp arg) {
        ConstrExp exp = new ConstrExp();
        exp.setName(name);
        exp.setArg(arg);
        return exp;
    }

    public Pattern any() {
        return new AnyPattern();
    }

    public ConstrPattern unionPattern(String name) {
        return this.unionPattern(name, null);
    }

    public ConstrPattern unionPattern(String name, Pattern arg) {
        ConstrPattern pat = new ConstrPattern();
        pat.setName(name);
        pat.setArg(arg);
        return pat;
    }

    public LocalVariable localVariable(String name, Type type) {
        return this.localVariable(name, type, this.initialValue(type));
    }

    public LocalVariable localVariable(String name, Type type, Exp value) {
        LocalVariable var = new LocalVariable();
        var.setName(name);
        var.setType(type);
        var.setInitializer(value);
        return var;
    }

    public Transition transition(String source, ProcessDecl process) {
        Transition transition = new Transition();
        transition.setFrom(this.ensureState(source, process));
        return transition;
    }

    public Transition transition(State state, ProcessDecl result) {
        Transition transition = new Transition();
        result.addTransition(transition);
        transition.setFrom(state);
        return transition;
    }

    public TypeDecl typeDecl(String name, Type type) {
        TypeDecl decl = new TypeDecl();
        decl.setName(name);
        decl.setIs(type);
        this.attachComments(decl, "creation type " + name);
        return decl;
    }

    public Type type(TypeDecl td) {
        TypeId typeID = new TypeId();
        typeID.setDecl(td);
        return typeID;
    }

    public VarRef varRef(Variable var) {
        VarRef ref = new VarRef();
        ref.setDecl(var);
        return ref;
    }

    public RefArg refArg(Variable var) {
        RefArg result = new RefArg();
        result.setRef(var);
        return result;
    }

    public State ensureState(String name, ProcessDecl process) {
        State state = this.findState(name, process);
        if (state != null) {
            return state;
        }
        return this.state(name, process);
    }

    public State findState(String name, ProcessDecl process) {
        for (State state : process.getStateList()) {
            if (!state.getName().equals(name)) continue;
            return state;
        }
        return null;
    }

    public void attachComments(Commented commented, String ... comments) {
        for (String comment : comments) {
            commented.addComment(comment);
        }
    }

    public void attachComment(Commented commented, String comment) {
        this.attachComments(commented, comment);
    }
}

