/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import obp.fiacre.model.ArgumentVariable;
import obp.fiacre.model.Declaration;
import obp.fiacre.model.LocalVariable;
import obp.fiacre.model.ModelVisitor;
import obp.fiacre.model.Variable;
import org.xid.basics.serializer.Boost;
import org.xid.basics.serializer.BoostObject;
import org.xid.basics.serializer.BoostUtil;

public abstract class ContainerDecl
extends Declaration
implements BoostObject {
    private final List<ArgumentVariable> argList = new ArrayList<ArgumentVariable>();
    private final List<LocalVariable> varList = new ArrayList<LocalVariable>();

    public ContainerDecl() {
    }

    protected ContainerDecl(Boost boost) {
        super(boost);
        for (Variable oneChild : BoostUtil.readObjectList((Boost)boost, ArgumentVariable.class)) {
            this.argList.add((ArgumentVariable)oneChild);
        }
        for (Variable oneChild : BoostUtil.readObjectList((Boost)boost, LocalVariable.class)) {
            this.varList.add((LocalVariable)oneChild);
        }
    }

    public List<ArgumentVariable> getArgList() {
        return Collections.unmodifiableList(this.argList);
    }

    public int getArgCount() {
        return this.argList.size();
    }

    public ArgumentVariable getArg(int index) {
        if (index < 0 || index >= this.getArgCount()) {
            return null;
        }
        return this.argList.get(index);
    }

    public void addArg(ArgumentVariable newValue) {
        this.addArg(this.getArgCount(), newValue);
    }

    public void addArg(int index, ArgumentVariable newValue) {
        this.argList.add(index, newValue);
    }

    public ArgumentVariable setArg(int index, ArgumentVariable newValue) {
        return this.argList.set(index, newValue);
    }

    public void addAllArg(Collection<ArgumentVariable> toAddList) {
        for (ArgumentVariable newValue : toAddList) {
            this.addArg(this.getArgCount(), newValue);
        }
    }

    public void removeArg(ArgumentVariable value) {
        int index = this.argList.indexOf(value);
        if (index >= 0) {
            this.removeArg(index);
        }
    }

    public void removeArg(int index) {
        this.argList.remove(index);
    }

    public List<LocalVariable> getVarList() {
        return Collections.unmodifiableList(this.varList);
    }

    public int getVarCount() {
        return this.varList.size();
    }

    public LocalVariable getVar(int index) {
        if (index < 0 || index >= this.getVarCount()) {
            return null;
        }
        return this.varList.get(index);
    }

    public void addVar(LocalVariable newValue) {
        this.addVar(this.getVarCount(), newValue);
    }

    public void addVar(int index, LocalVariable newValue) {
        this.varList.add(index, newValue);
    }

    public LocalVariable setVar(int index, LocalVariable newValue) {
        return this.varList.set(index, newValue);
    }

    public void addAllVar(Collection<LocalVariable> toAddList) {
        for (LocalVariable newValue : toAddList) {
            this.addVar(this.getVarCount(), newValue);
        }
    }

    public void removeVar(LocalVariable value) {
        int index = this.varList.indexOf(value);
        if (index >= 0) {
            this.removeVar(index);
        }
    }

    public void removeVar(int index) {
        this.varList.remove(index);
    }

    @Override
    public void writeToBoost(Boost boost) {
        super.writeToBoost(boost);
        BoostUtil.writeObjectCollection((Boost)boost, this.argList);
        BoostUtil.writeObjectCollection((Boost)boost, this.varList);
    }

    @Override
    public abstract void accept(ModelVisitor var1);
}

