/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.checker.type;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import obp.fiacre.checker.type.CAny;
import obp.fiacre.checker.type.CType;

public class CRecord
extends CType {
    private final List<String> fieldList = new ArrayList<String>();
    private final List<CType> typeList = new ArrayList<CType>();

    public void addField(String name, CType type) {
        this.fieldList.add(name);
        this.typeList.add(type);
    }

    public CType getField(String name) {
        for (int i = 0; i < this.fieldList.size(); ++i) {
            if (!name.equals(this.fieldList.get(i))) continue;
            return this.typeList.get(i);
        }
        throw new IllegalArgumentException("Field '" + name + "' doesn't exist in type '" + this + "'.");
    }

    public List<String> getFieldList() {
        return Collections.unmodifiableList(this.fieldList);
    }

    @Override
    public boolean isAssignableFrom(CType type) {
        if (type == null) {
            return false;
        }
        if (this == type) {
            return true;
        }
        if ((type = type.resolve()) == CAny.anyType) {
            return true;
        }
        if (!(type instanceof CRecord)) {
            return false;
        }
        CRecord other = (CRecord)type;
        for (int i = 0; i < this.fieldList.size(); ++i) {
            String name = this.fieldList.get(i);
            int otherIndexOf = other.fieldList.indexOf(name);
            if (otherIndexOf < 0) {
                return false;
            }
            if (this.typeList.get(i).isAssignableFrom(other.typeList.get(otherIndexOf))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CRecord) {
            CRecord other = (CRecord)obj;
            if (!this.fieldList.equals(other.fieldList)) {
                return false;
            }
            return this.typeList.equals(other.typeList);
        }
        return false;
    }

    public String toString() {
        StringBuilder string = new StringBuilder();
        string.append("record{");
        for (int i = 0; i < this.fieldList.size(); ++i) {
            if (i > 0) {
                string.append(",");
            }
            string.append(this.fieldList.get(i));
            string.append(":");
            string.append(this.typeList.get(i));
        }
        string.append("}");
        return string.toString();
    }
}

