/*
 * Decompiled with CFR 0.152.
 */
package obp2.cli;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import obp2.core.execution.Execution;
import obp2.language.buchikripke.runtime.KripkeBuchiLanguageModule;
import obp2.runtime.core.ILanguageModule;
import obp2.simulation.trace_storage.TraceEntry;
import obp2.simulation.trace_storage.TraceStore;

public abstract class CounterExampleExtractor {
    String propertyToVerify;
    boolean checkForDeadlocks;
    boolean onlyKripke;
    List<TraceEntry> counterExample = new ArrayList<TraceEntry>();
    ILanguageModule module;

    protected CounterExampleExtractor(String propertyToVerify, boolean checkForDeadlocks, boolean onlyKripke) {
        this.propertyToVerify = propertyToVerify;
        this.checkForDeadlocks = checkForDeadlocks;
        this.onlyKripke = onlyKripke;
    }

    public CounterExampleExtractor buildCounterExample(Execution execution) throws InterruptedException {
        if (execution.verificationStatus() == Execution.VerificationStatus.UNKNOWN) {
            this.counterExample = Collections.emptyList();
        }
        if (!execution.traceStore.hasCounterExample()) {
            this.counterExample = Collections.emptyList();
        }
        this.module = execution.getTransitionRelation().getModule();
        return this.buildCounterExample(execution.traceStore);
    }

    CounterExampleExtractor buildCounterExample(TraceStore traceStore) {
        traceStore.setAddStepUserCallback(this::addStepCallback);
        traceStore.iterateOverTrace();
        return this;
    }

    private void addStepCallback(Object in) {
        TraceEntry entry = (TraceEntry)in;
        this.counterExample.add(entry);
    }

    boolean showOnlyKripke() {
        return this.onlyKripke && this.propertyToVerify != null && !this.checkForDeadlocks;
    }

    ILanguageModule getKripkeModule() {
        return ((KripkeBuchiLanguageModule)this.module).kripke;
    }

    abstract CounterExampleExtractor toStringCounterExample(PrintStream var1);

    abstract CounterExampleExtractor toBinaryCounterExample(PrintStream var1);
}

