/*
 * Decompiled with CFR 0.152.
 */
package obp2.visualisation;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import obp2.core.IFiredTransition;
import obp2.core.IGraphAccess;

public class StateSpace2TGF<C, A, O> {
    public static final StateSpace2TGF instace = new StateSpace2TGF();

    public static void toTGF(IGraphAccess graphView, String filename) {
        try {
            instace.toTGF(graphView, false, false, filename);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void toTGF(IGraphAccess graphView, boolean vertexDetails, String filename) {
        try {
            instace.toTGF(graphView, vertexDetails, false, filename);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void toTGF(IGraphAccess<C, A, O> graphView, boolean vertexDetails, boolean edgeDetails, String filename) throws IOException {
        BufferedWriter br = new BufferedWriter(new FileWriter(filename));
        this.toTGF(graphView, vertexDetails, edgeDetails, br);
    }

    public void toTGF(IGraphAccess<C, A, O> graphView, boolean vertexDetails, boolean edgeDetails, Writer writer) throws IOException {
        HashMap idMap = new HashMap();
        writer.write("0 i\n");
        for (Object vertex : graphView.getVertices()) {
            int id = this.getID(vertex, idMap);
            writer.write(id + " " + (vertexDetails ? vertex.toString() : "") + "\n");
        }
        writer.write("#\n");
        for (Object vertex : graphView.getInitialVertices()) {
            writer.write("0 " + this.getID(vertex, idMap) + "\n");
        }
        for (Object source : graphView.getVertices()) {
            int sourceID = this.getID(source, idMap);
            for (IFiredTransition transition : graphView.getOutgoingEdges(source)) {
                String actionString = transition.getAction() == null ? "" : transition.getAction().toString();
                for (Object target : transition.getTargets()) {
                    writer.write(sourceID + " " + this.getID(target, idMap) + " " + (edgeDetails ? actionString : "") + "\n");
                }
            }
        }
        writer.close();
    }

    int getID(C vertex, Map<C, Integer> idMap) {
        Integer id = idMap.get(vertex);
        if (id == null) {
            id = idMap.size() + 1;
            idMap.put(vertex, id);
        }
        return id;
    }
}

