/*
 * Decompiled with CFR 0.152.
 */
package obp2.language.state_event.diagnosis.dsl.evaluator;

import obp2.language.state_event.diagnosis.dsl.DiagnosisModelVisitor;
import obp2.language.state_event.diagnosis.dsl.model.BinaryExp;
import obp2.language.state_event.diagnosis.dsl.model.ClockRef;
import obp2.language.state_event.diagnosis.dsl.model.ConditionalExp;
import obp2.language.state_event.diagnosis.dsl.model.DiagnosisExp;
import obp2.language.state_event.diagnosis.dsl.model.LiteralExp;
import obp2.language.state_event.diagnosis.dsl.model.NextVariableRef;
import obp2.language.state_event.diagnosis.dsl.model.TransitionRef;
import obp2.language.state_event.diagnosis.dsl.model.UnaryExp;
import obp2.language.state_event.diagnosis.dsl.model.VariableRef;
import obp2.language.state_event.model.StateEventModel;

public class Linker
implements DiagnosisModelVisitor<Boolean> {
    StateEventModel model;

    public void link(DiagnosisExp expression, StateEventModel model) {
        this.model = model;
        expression.accept(this);
    }

    @Override
    public Boolean visit(LiteralExp expr) {
        return true;
    }

    @Override
    public Boolean visit(ClockRef expr) {
        Integer index = this.model.events.get(expr.getName());
        if (index == null) {
            System.err.println("The clock " + expr.getName() + " is not present in the model");
            expr.setIndex(-1);
        }
        expr.setIndex(index);
        return true;
    }

    @Override
    public Boolean visit(TransitionRef expr) {
        if (expr.getIndex() < 0 || expr.getIndex() >= this.model.nbTransitions) {
            System.err.println("The system does not have a transition at index " + expr.getIndex());
            expr.setIndex(-1);
        }
        return true;
    }

    @Override
    public Boolean visit(VariableRef expr) {
        Integer index = this.model.variables.get(expr.getName());
        if (index == null) {
            System.err.println("The variable " + expr.getName() + " is not present in the model");
            expr.setIndex(-1);
        }
        expr.setIndex(index);
        return true;
    }

    @Override
    public Boolean visit(NextVariableRef expr) {
        Integer index = this.model.variables.get(expr.getName());
        if (index == null) {
            System.err.println("The variable " + expr.getName() + " is not present in the model");
            expr.setIndex(-1);
        }
        return true;
    }

    @Override
    public Boolean visit(UnaryExp expr) {
        return expr.getOperand().accept(this);
    }

    @Override
    public Boolean visit(BinaryExp expr) {
        expr.getLhs().accept(this);
        expr.getRhs().accept(this);
        return true;
    }

    @Override
    public Boolean visit(ConditionalExp expr) {
        expr.getCondition().accept(this);
        expr.getTrueBranch().accept(this);
        expr.getFalseBranch().accept(this);
        return true;
    }
}

