/*
 * Decompiled with CFR 0.152.
 */
package obp2.algorithms.bitstate;

import announce4j.Announcer;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.Stack;
import obp2.algorithms.bitstate.BloomFilter;
import obp2.core.IConfiguration;
import obp2.core.IStateSpaceManager;
import obp2.core.execution.IExecutionController;
import obp2.core.execution.IExecutionMonitor;
import obp2.events.ExecutionEndedEvent;
import obp2.operators.bytearray.ByteArrayLanguageModule;
import obp2.runtime.core.ISimpleTransitionRelation;
import obp2.runtime.core.ITransitionRelation;
import obp2.runtime.core.STR2TR;

public class BitstateExplorer<C extends IConfiguration, A>
implements IExecutionController<C, A> {
    protected final Announcer announcer = new Announcer(true);
    protected final IExecutionMonitor.Simple monitor = new IExecutionMonitor.Simple();
    ByteArrayLanguageModule languageModule;
    ISimpleTransitionRelation<byte[]> simpleTransitionRelation;
    BigInteger stepCount = BigInteger.ZERO;
    protected final Stack<StackEntry> frontier = new Stack();
    protected final BloomFilter known = new BloomFilter();

    public BitstateExplorer(ITransitionRelation<Object, Object, Object> runtime, IStateSpaceManager<C, A, Object> stateSpaceManager) {
        this.languageModule = new ByteArrayLanguageModule(runtime.getModule());
        this.simpleTransitionRelation = new STR2TR(this.languageModule.getTransitionRelation());
    }

    public Announcer getAnnouncer() {
        return this.announcer;
    }

    public IStateSpaceManager<C, A, Object> getStateSpaceManager() {
        return null;
    }

    public BigInteger configurationCount() {
        return BigInteger.valueOf(this.known.size());
    }

    public BigInteger stepCount() {
        return this.stepCount;
    }

    public ITransitionRelation<C, A, Object> getRuntime() {
        return null;
    }

    public IExecutionMonitor getMonitor() {
        return this.monitor;
    }

    public void execute() {
        this.initializeExploration();
        while (!this.monitor.atEnd() && !this.atEnd()) {
            this.explorationStep();
        }
        this.announcer.announce((Object)new ExecutionEndedEvent((IExecutionController)this));
    }

    void initializeExploration() {
        for (byte[] c : this.simpleTransitionRelation.initialConfigurations()) {
            this.known.add(c);
            this.frontier.push(new StackEntry(c));
        }
    }

    void explorationStep() {
        StackEntry current = this.frontier.peek();
        if (current.hasNext()) {
            byte[] target = current.next();
            if (this.known.add(target)) {
                this.frontier.push(new StackEntry(target));
            }
            this.stepCount = this.stepCount.add(BigInteger.ONE);
            return;
        }
        this.frontier.pop();
    }

    boolean atEnd() {
        return this.frontier.isEmpty();
    }

    class StackEntry
    implements Iterator {
        byte[] configuration;
        Iterator<byte[]> postIterator;

        public StackEntry(byte[] configuration) {
            this.configuration = configuration;
        }

        @Override
        public boolean hasNext() {
            if (this.postIterator == null) {
                this.postIterator = BitstateExplorer.this.simpleTransitionRelation.next((Object)this.configuration).iterator();
            }
            return this.postIterator.hasNext();
        }

        public byte[] next() {
            if (this.postIterator == null) {
                this.postIterator = BitstateExplorer.this.simpleTransitionRelation.next((Object)this.configuration).iterator();
            }
            return this.postIterator.next();
        }
    }
}

