/*
 * Decompiled with CFR 0.152.
 */
package org.cte.ABCD.compiler;

import java.io.File;
import java.io.IOException;
import org.antlr.v4.runtime.ANTLRFileStream;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.cte.ABCD.compiler.ASTBuilder;
import org.cte.ABCD.compiler.FunctionResolver;
import org.cte.ABCD.compiler.InstantiationChecker;
import org.cte.ABCD.compiler.ProcessResolver;
import org.cte.ABCD.grammar.ABCDLexer;
import org.cte.ABCD.grammar.ABCDParser;
import org.cte.ABCD.model.declarations.ABCDSystem;

public class Compiler {
    private static Compiler instance = new Compiler();

    public static ABCDSystem compile(File file) throws IOException {
        ANTLRFileStream fs = new ANTLRFileStream(file.getAbsolutePath());
        return instance.compile((ANTLRInputStream)fs);
    }

    public static ABCDSystem compile(String abcdProgram) throws IOException {
        ANTLRInputStream is = new ANTLRInputStream(abcdProgram);
        return instance.compile(is);
    }

    public ABCDSystem compile(ANTLRInputStream is) {
        ABCDLexer lexer = new ABCDLexer((CharStream)is);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        ABCDParser parser = new ABCDParser((TokenStream)tokens);
        ABCDParser.SystemContext tree = parser.system();
        ParseTreeWalker walker = new ParseTreeWalker();
        ASTBuilder builder = new ASTBuilder();
        ABCDSystem system = null;
        try {
            walker.walk((ParseTreeListener)builder, (ParseTree)tree);
            system = builder.getResult();
        }
        catch (Error e) {
            System.err.println(e.getMessage());
            return null;
        }
        FunctionResolver fResolver = new FunctionResolver(system);
        fResolver.resolveAndBind();
        ProcessResolver pResolver = new ProcessResolver(system);
        pResolver.resolveAndBind();
        InstantiationChecker iC = new InstantiationChecker(system);
        iC.checkInstances();
        return system;
    }
}

