/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.compiler;

import java.util.Map;
import java.util.Set;
import obp.explorer.runtime.util.NameUtil;
import obp.fiacre.checker.type.CAny;
import obp.fiacre.checker.type.CBool;
import obp.fiacre.checker.type.CExisting;
import obp.fiacre.checker.type.CInt;
import obp.fiacre.checker.type.CType;
import obp.fiacre.checker.type.ExpCTypeInferrer;
import obp.fiacre.compiler.AssignmentGenerator;
import obp.fiacre.compiler.ExpressionGenerator;
import obp.fiacre.compiler.PatternGenerator;
import obp.fiacre.compiler.ProgramGenerator;
import obp.fiacre.model.AnyPattern;
import obp.fiacre.model.ArgumentVariable;
import obp.fiacre.model.CaseStmt;
import obp.fiacre.model.DeterministicAssignment;
import obp.fiacre.model.Emission;
import obp.fiacre.model.Exp;
import obp.fiacre.model.Foreach;
import obp.fiacre.model.IfStmt;
import obp.fiacre.model.Interval;
import obp.fiacre.model.ModelVisitor;
import obp.fiacre.model.NonDeterministicAssignment;
import obp.fiacre.model.NullStmt;
import obp.fiacre.model.Pattern;
import obp.fiacre.model.PatternStmt;
import obp.fiacre.model.PortDecl;
import obp.fiacre.model.Profile;
import obp.fiacre.model.Reception;
import obp.fiacre.model.ReturnStmt;
import obp.fiacre.model.Rule;
import obp.fiacre.model.Select;
import obp.fiacre.model.Seq;
import obp.fiacre.model.SingleAssignment;
import obp.fiacre.model.Statement;
import obp.fiacre.model.Synchronization;
import obp.fiacre.model.To;
import obp.fiacre.model.Type;
import obp.fiacre.model.Variable;
import obp.fiacre.model.Wait;
import obp.fiacre.model.WhileStmt;
import obp.fiacre.util.CommentedUtil;
import obp.fiacre.util.FiacrePrinter;
import obp.fiacre.util.StatementUtil;
import obp.fiacre.util.TypeUtil;
import org.xid.basics.generation.java.JavaContentHandler;

public class StatementGenerator
extends ModelVisitor.Stub {
    private final ExpCTypeInferrer inferrer = new ExpCTypeInferrer();
    private final ProgramGenerator caller;
    private final JavaContentHandler content;
    private int currentLevel;
    private Mode generationMode;
    private CType functionReturnType;

    public StatementGenerator(ProgramGenerator caller) {
        this.caller = caller;
        this.content = caller.getContent();
    }

    public Map<Type, String> getTypeNames() {
        return this.caller.getTypeNames();
    }

    public ExpressionGenerator getExpressionGenerator() {
        return this.caller.getExpressionGenerator();
    }

    public AssignmentGenerator getAssignmentGenerator() {
        return this.caller.getAssignmentGenerator();
    }

    public PatternGenerator getPatternGenerator() {
        return this.caller.getPatternGenerator();
    }

    public int getCurrentLevel() {
        return this.currentLevel;
    }

    public void generateForModifiedBehaviors(Statement statement) {
        Set<Variable> modifiedVariables = StatementUtil.findModifiedVariables(statement);
        for (Variable usedVariable : modifiedVariables) {
            ArgumentVariable argument;
            if (!(usedVariable instanceof ArgumentVariable) || !(argument = (ArgumentVariable)usedVariable).isRef()) continue;
            String name = NameUtil.uncapName(argument.getName());
            this.content.codeln(0, "modifiedBehaviors[" + name + "Ref.ownerId] = true;");
        }
    }

    public void generateForInit(Statement statement) {
        this.currentLevel = 0;
        this.generationMode = Mode.Init;
        this.functionReturnType = null;
        statement.accept(this);
    }

    public void generateForTransition(int level, Statement statement) {
        this.currentLevel = level;
        this.generationMode = Mode.Transition;
        this.functionReturnType = null;
        statement.accept(this);
    }

    public void generateForFunction(int level, Statement statement, CType returnType) {
        this.currentLevel = level;
        this.generationMode = Mode.Function;
        this.functionReturnType = returnType;
        statement.accept(this);
    }

    private String generateExpression(CType type, Exp exp) {
        if (this.generationMode == Mode.Function) {
            return this.getExpressionGenerator().generateForFunction(type, exp);
        }
        return this.getExpressionGenerator().generateForBehavior(type, exp);
    }

    private void generateAssignement(int level, Pattern pattern, String expression) {
        if (this.generationMode == Mode.Function) {
            this.getAssignmentGenerator().generateForFunction(level, pattern, expression);
        } else {
            this.getAssignmentGenerator().generateForTransition(level, pattern, expression);
        }
    }

    private void generateInformals(Statement statement) {
        for (String comment : statement.getCommentList()) {
            String informal = CommentedUtil.informalFromComment(comment);
            if (informal == null) continue;
            String name = "informal" + this.caller.getNodeAnalyzer().getInformalMap().get(informal);
            this.caller.getDependencyManager().getShortName("obp.explorer.runtime.obs.InformalAction");
            this.content.codeln(this.currentLevel, "actions.add(new InformalAction(id, " + name + "));");
        }
    }

    @Override
    public void visitDeterministicAssignment(DeterministicAssignment toVisit) {
        this.generateInformals(toVisit);
        for (SingleAssignment assignment : toVisit.getAssignmentList()) {
            Pattern lhs = assignment.getLhs();
            if (lhs instanceof AnyPattern) {
                String rhsCode = this.generateExpression(CAny.anyType, assignment.getRhs());
                this.content.codeln(this.currentLevel, rhsCode + ";");
                continue;
            }
            CType cType = this.inferrer.infer(assignment.getLhs());
            String rhsCode = this.generateExpression(cType, assignment.getRhs());
            this.generateAssignement(this.currentLevel, lhs, rhsCode);
        }
    }

    @Override
    public void visitNonDeterministicAssignment(NonDeterministicAssignment toVisit) {
        throw new IllegalArgumentException("NonDeterministicAssignment aren't not supported.");
    }

    @Override
    public void visitCaseStmt(CaseStmt toVisit) {
        this.generateInformals(toVisit);
        CType cType = this.inferrer.infer(toVisit.getExp());
        String expression = this.generateExpression(cType, toVisit.getExp());
        Pattern lastPattern = null;
        for (int i = 0; i < toVisit.getRuleCount(); ++i) {
            Rule rule = toVisit.getRule(i);
            lastPattern = rule.getLhs();
            this.getPatternGenerator().generateTest(i == 0, cType, expression, lastPattern);
            ++this.currentLevel;
            rule.getAction().accept(this);
            --this.currentLevel;
        }
        if (!(lastPattern instanceof AnyPattern) && this.generationMode == Mode.Transition) {
            this.getPatternGenerator().generateTest(false, cType, null, new AnyPattern());
            ++this.currentLevel;
            this.content.codeln(this.currentLevel, "if (true) { return false; }");
            --this.currentLevel;
        }
        this.content.codeln(this.currentLevel, "}");
    }

    @Override
    public void visitEmission(Emission toVisit) {
        this.generateInformals(toVisit);
        String name = NameUtil.uncapName(toVisit.getPort().getName());
        StringBuilder code = new StringBuilder();
        code.append(name);
        code.append(".output(id, actions");
        Profile profile = (Profile)toVisit.getPort().getChannel();
        for (int i = 0; i < toVisit.getArgCount(); ++i) {
            code.append(", ");
            CExisting cType = new CExisting(profile.getType(i));
            code.append(this.generateExpression(cType, toVisit.getArg(i)));
        }
        code.append(");");
        this.content.codeln(this.currentLevel, code.toString());
    }

    @Override
    public void visitReception(Reception toVisit) {
        this.generateInformals(toVisit);
        String name = NameUtil.uncapName(toVisit.getPort().getName());
        Profile profile = (Profile)toVisit.getPort().getChannel();
        this.content.codeln(this.currentLevel, name + ".input(id, actions);");
        for (int i = 0; i < toVisit.getPatternCount(); ++i) {
            StringBuilder code = new StringBuilder();
            code.append(name);
            code.append(".value(");
            code.append(TypeUtil.toJavaDeclaration(profile.getType(i), this.getTypeNames()));
            code.append(".class,");
            code.append(i);
            code.append(")");
            Pattern left = toVisit.getPattern(i);
            this.generateAssignement(this.currentLevel, left, code.toString());
        }
        this.caller.getDependencyManager().getShortName("obp.explorer.runtime.core.Channel");
        this.caller.getDependencyManager().getShortName("obp.explorer.runtime.DBM");
        this.content.codeln(this.currentLevel, "if ( " + name + ".clockId != -1 ) {");
        this.content.codeln(this.currentLevel + 1, "DBM.set(configuration.dbm, " + name + ".clockId, 0);");
        this.content.codeln(this.currentLevel, "}");
    }

    @Override
    public void visitSynchronization(Synchronization toVisit) {
        this.generateInformals(toVisit);
        PortDecl port = toVisit.getPort();
        String name = NameUtil.uncapName(toVisit.getPort().getName());
        if (port.isIn() && !port.isOut()) {
            StringBuilder code = new StringBuilder();
            code.append(name);
            code.append(".input(id, actions);");
            this.content.codeln(this.currentLevel, code.toString());
            this.caller.getDependencyManager().getShortName("obp.explorer.runtime.core.Channel");
            this.caller.getDependencyManager().getShortName("obp.explorer.runtime.DBM");
            this.content.codeln(this.currentLevel, "if ( " + name + ".clockId != -1 ) {");
            this.content.codeln(this.currentLevel + 1, "DBM.set(configuration.dbm, " + name + ".clockId, 0);");
            this.content.codeln(this.currentLevel, "}");
        } else if (!port.isIn() && port.isOut()) {
            StringBuilder code = new StringBuilder();
            code.append(name);
            code.append(".output(id, actions);");
            this.content.codeln(this.currentLevel, code.toString());
        } else {
            throw new IllegalArgumentException("Can't determinate synchronous direction for port '" + port.getName() + "'.");
        }
    }

    @Override
    public void visitWait(Wait toVisit) {
        this.generateInformals(toVisit);
        this.caller.getDependencyManager().getShortName("obp.explorer.runtime.core.Channel");
        this.caller.getDependencyManager().getShortName("obp.explorer.runtime.DBM");
        String name = this.caller.getNodeAnalyzer().getWaitNameMap().get(toVisit);
        this.content.codeln(this.currentLevel, "DBM.set(configuration.dbm, " + name + ".clockId, 0);");
        this.caller.getDependencyManager().getShortName("obp.explorer.runtime.obs.DelayAction");
        this.content.codeln(this.currentLevel, "actions.add(new DelayAction(id));");
    }

    @Override
    public void visitForeach(Foreach toVisit) {
        this.generateInformals(toVisit);
        Type type = TypeUtil.referencedType(toVisit.getIter().getType());
        String iterName = NameUtil.uncapName(toVisit.getIter().getName());
        if (this.caller.getVariableAnalyser().isConfigurationVariable(toVisit.getIter()) && this.generationMode == Mode.Transition) {
            iterName = "me." + iterName;
        }
        if (!(type instanceof Interval)) {
            throw new IllegalArgumentException("Can't use variable '" + iterName + "' of type '" + FiacrePrinter.toString(toVisit.getIter().getType()) + "' in a foreach.");
        }
        Interval interval = (Interval)type;
        String mini = this.generateExpression(CInt.intType, interval.getMini());
        String maxi = this.generateExpression(CInt.intType, interval.getMaxi());
        this.content.codeln(this.currentLevel, "for ( " + iterName + " = " + mini + "; " + iterName + " <= " + maxi + "; " + iterName + "++ ) {");
        ++this.currentLevel;
        toVisit.getBody().accept(this);
        --this.currentLevel;
        this.content.codeln(this.currentLevel, "}");
    }

    @Override
    public void visitIfStmt(IfStmt toVisit) {
        this.generateInformals(toVisit);
        this.content.codeln(this.currentLevel, "if (" + this.generateExpression(CBool.boolType, toVisit.getCondition()) + ") {");
        ++this.currentLevel;
        toVisit.getThen().accept(this);
        --this.currentLevel;
        if (toVisit.getElse() != null && !(toVisit.getElse() instanceof NullStmt)) {
            this.content.codeln(this.currentLevel, "} else {");
            ++this.currentLevel;
            toVisit.getElse().accept(this);
            --this.currentLevel;
            this.content.codeln(this.currentLevel, "}");
        } else {
            this.content.codeln(this.currentLevel, "}");
        }
    }

    @Override
    public void visitNullStmt(NullStmt toVisit) {
        this.generateInformals(toVisit);
    }

    @Override
    public void visitSelect(Select toVisit) {
        throw new IllegalArgumentException("Select statement should be split upstream (shoudn't happen contact OBP team).");
    }

    @Override
    public void visitSeq(Seq toVisit) {
        this.generateInformals(toVisit);
        for (Statement child : toVisit.getStatementList()) {
            child.accept(this);
        }
    }

    @Override
    public void visitTo(To toVisit) {
        this.generateInformals(toVisit);
        if (this.generationMode == Mode.Function) {
            throw new IllegalArgumentException("To statement are not allowed in functions.");
        }
        String name = NameUtil.capName(toVisit.getDest().getName());
        this.content.codeln(this.currentLevel, "me.state = " + name + ";");
        if (this.generationMode == Mode.Transition) {
            this.content.codeln(this.currentLevel, "if (true) return true;");
        }
    }

    @Override
    public void visitReturnStmt(ReturnStmt toVisit) {
        this.generateInformals(toVisit);
        if (this.generationMode != Mode.Function) {
            throw new IllegalArgumentException("Return statement are only allowed in functions.");
        }
        String expressionCode = this.generateExpression(this.functionReturnType, toVisit.getExpression());
        this.content.codeln(this.currentLevel, "return " + expressionCode + ";");
    }

    @Override
    public void visitWhileStmt(WhileStmt toVisit) {
        this.generateInformals(toVisit);
        this.content.codeln(this.currentLevel, "while (" + this.generateExpression(CBool.boolType, toVisit.getCondition()) + ") {");
        ++this.currentLevel;
        toVisit.getBody().accept(this);
        --this.currentLevel;
        this.content.codeln(this.currentLevel, "}");
    }

    @Override
    public void visitPatternStmt(PatternStmt toVisit) {
        CType cType = this.inferrer.infer(toVisit.getExp());
        String expression = this.generateExpression(cType, toVisit.getExp());
        this.getPatternGenerator().generateAssignment(cType, expression, toVisit.getPattern());
    }

    public static enum Mode {
        Init,
        Transition,
        Function;

    }
}

