/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.compiler;

import java.util.List;
import obp.explorer.runtime.util.NameUtil;
import obp.fiacre.compiler.NodeGenerator;
import obp.fiacre.compiler.ProgramGenerator;
import obp.fiacre.model.ProcessDecl;
import obp.fiacre.model.Wait;
import org.xid.basics.generation.java.Java;

public class ProcessGenerator
extends NodeGenerator {
    public ProcessGenerator(ProgramGenerator caller) {
        super(caller);
    }

    public void generateProcess(ProcessDecl processDecl) {
        this.createConfigurationClass(processDecl);
        this.createBehaviorClass(processDecl);
    }

    private void createConfigurationClass(ProcessDecl process) {
        this.getDependencyManager().clear();
        String configurationName = ProgramGenerator.getConfigurationName(process);
        this.content.beginFile(configurationName + ".java");
        this.content.markImports();
        this.getDependencyManager().getShortName("obp.explorer.runtime.BehaviorConfiguration");
        this.content.annotation("SuppressWarnings", "\"all\"");
        this.content.beginClass(4, configurationName, "BehaviorConfiguration", null);
        this.generateConfigurationFields(process);
        this.generateConfigurationConstructors(process);
        this.content.annotation("Override", null);
        this.content.beginMethod(4, "BehaviorConfiguration", "createCopy", null, new Java.Parameter[0]);
        this.content.codeln(0, "return new " + configurationName + "(this);");
        this.content.endMethod("createCopy");
        this.generateConfigurationEqualsAndHashCode(process);
        this.content.endClass(configurationName);
        this.caller.generateImports();
        this.content.endFile(configurationName + ".java");
    }

    private void createBehaviorClass(ProcessDecl process) {
        String processBehaviorName = ProgramGenerator.getBehaviorName(process);
        this.getDependencyManager().clear();
        this.content.beginFile(processBehaviorName + ".java");
        this.content.markImports();
        this.getDependencyManager().getShortName("obp.explorer.runtime.core.Transition");
        this.getDependencyManager().getShortName("obp.explorer.runtime.ProcessBehavior");
        this.content.annotation("SuppressWarnings", "\"all\"");
        this.content.beginClass(4, processBehaviorName, "ProcessBehavior", null);
        this.generateIdSeedField();
        this.generateBehaviorStates(process);
        this.generateBehaviorFields(process);
        this.generateBehaviorConstructors(process);
        this.generateGetStateIdMethod(process);
        this.getTransitionGenerator().generateProcessBehaviorTransitions(process);
        this.generateBehaviorInitialConfigurationMethod(process);
        this.generateBehaviorToString(process);
        this.generateBehaviorReadWriteConfigurationMethod(process);
        this.content.endClass(processBehaviorName);
        this.caller.generateImports();
        this.content.endFile(processBehaviorName + ".java");
    }

    private void generateBehaviorStates(ProcessDecl process) {
        for (int i = 0; i < process.getStateCount(); ++i) {
            String name = NameUtil.capName(process.getState(i).getName());
            this.content.beginAttribute(28, "short", name);
            this.content.code(Integer.toString(i + 1));
            this.content.endAttribute(name);
        }
    }

    private void generateGetStateIdMethod(ProcessDecl process) {
        this.content.beginAttribute(17, "String[]", "stateNames");
        StringBuilder init = new StringBuilder();
        init.append("new String[] {");
        for (int i = 0; i < process.getStateCount(); ++i) {
            if (i > 0) {
                init.append(", ");
            }
            init.append("\"");
            init.append(process.getState(i).getName());
            init.append("\"");
        }
        init.append("}");
        this.content.code(init.toString());
        this.content.endAttribute("stateNames");
        this.content.beginMethod(4, "int", "getStateId", null, new Java.Parameter[]{new Java.Parameter(0, "String", "name")});
        this.content.codeln(0, "for (short i=0; i<stateNames.length; i++) {");
        this.content.codeln(1, "if ( stateNames[i].equals(name) ) return (i+1);");
        this.content.codeln(0, "}");
        this.content.codeln(0, "throw new IllegalArgumentException(\"State '\"+ name +\"' doesn't exist in process '\"+ this.name +\"'.\");");
        this.content.endMethod("getStateId");
        this.content.beginMethod(4, "String", "getStateName", null, new Java.Parameter[]{new Java.Parameter(0, "short", "id")});
        this.content.codeln(0, "return stateNames[id-1];");
        this.content.endMethod("getStateName");
    }

    protected void generateBehaviorFields(ProcessDecl processDecl) {
        super.generateBehaviorFields(processDecl);
        List<Wait> waitList = this.getNodeAnalyzer().getProcessWaitList(processDecl);
        if (waitList.size() > 0) {
            for (Wait wait : waitList) {
                String name = this.getNodeAnalyzer().getWaitNameMap().get(wait);
                this.getDependencyManager().getShortName("obp.explorer.runtime.fiacre.WaitChannel");
                this.content.beginAttribute(17, "WaitChannel", name);
                this.content.endAttribute(name);
            }
            this.getDependencyManager().getShortName("obp.explorer.runtime.core.Channel");
            this.getDependencyManager().getShortName("java.util.List");
            this.getDependencyManager().getShortName("java.util.Arrays");
            this.content.beginAttribute(17, "Channel[]", "channels");
            this.content.endAttribute("channels");
            this.content.beginMethod(4, "void", "collectChannels", null, new Java.Parameter[]{new Java.Parameter(0, "List<Channel>", "result")});
            this.content.codeln(0, "result.addAll(Arrays.asList(channels));");
            this.content.endMethod("collectChannels");
        }
    }

    protected void generateBehaviorConstructors(ProcessDecl processDecl) {
        List<Wait> waitList;
        this.generateBehaviorConstructorsStart(processDecl);
        Short clockRangeSize = this.getClockBindingsGenerator().getClockIndexRangeSize(processDecl);
        if (clockRangeSize != null && clockRangeSize > 0) {
            this.content.codeln(0, "symbols.registerClockIndexes(this.getId(), (short) " + clockRangeSize + ");");
        }
        if ((waitList = this.getNodeAnalyzer().getProcessWaitList(processDecl)).size() > 0) {
            this.content.codeln(0, "");
            String channelShortname = this.getDependencyManager().getShortName("obp.explorer.runtime.core.Channel");
            StringBuilder channelArrayCode = new StringBuilder();
            channelArrayCode.append("channels = new " + channelShortname + "[] { ");
            for (Wait wait : waitList) {
                String name = this.getNodeAnalyzer().getWaitNameMap().get(wait);
                String waitShortname = this.getDependencyManager().getShortName("obp.explorer.runtime.fiacre.WaitChannel");
                StringBuilder code = new StringBuilder();
                code.append(name);
                code.append(" = new " + waitShortname + "(null, symbols");
                if (wait.getMini() != null && wait.getMaxi() != null) {
                    code.append(", this.getId()");
                    code.append(", (short) " + this.getClockBindingsGenerator().getWaitOffset(wait));
                    code.append(this.toJavaCode(wait.getMini()));
                    code.append(this.toJavaCode(wait.getMaxi()));
                }
                code.append(");");
                this.content.codeln(0, code.toString());
                channelArrayCode.append(name);
                channelArrayCode.append(", ");
            }
            channelArrayCode.append(" };");
            this.content.codeln(0, channelArrayCode.toString());
        }
        this.generateBehaviorConstructorsEnd(processDecl);
    }
}

