/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.checker.type;

import obp.fiacre.checker.type.CArray;
import obp.fiacre.checker.type.CBool;
import obp.fiacre.checker.type.CInt;
import obp.fiacre.checker.type.CQueue;
import obp.fiacre.checker.type.CRecord;
import obp.fiacre.checker.type.CType;
import obp.fiacre.checker.type.CUnion;
import obp.fiacre.model.Array;
import obp.fiacre.model.BoolType;
import obp.fiacre.model.Constr;
import obp.fiacre.model.Field;
import obp.fiacre.model.IntType;
import obp.fiacre.model.Interval;
import obp.fiacre.model.NatType;
import obp.fiacre.model.Queue;
import obp.fiacre.model.Record;
import obp.fiacre.model.Type;
import obp.fiacre.model.TypeId;
import obp.fiacre.model.Union;
import obp.fiacre.util.FiacrePrinter;
import obp.fiacre.util.TypeUtil;

public class CExisting
extends CType {
    private final Type existing;
    private final CType converted;

    public CExisting(Type existing) {
        this.existing = existing;
        this.converted = CExisting.convert(existing);
    }

    @Override
    public CType resolve() {
        return this.converted.resolve();
    }

    @Override
    public boolean isAssignableFrom(CType other) {
        if (other == null) {
            return false;
        }
        return this.converted.isAssignableFrom(other);
    }

    public boolean equals(Object obj) {
        if (obj instanceof CExisting) {
            CExisting other = (CExisting)obj;
            return this.existing == other.existing;
        }
        return false;
    }

    public String toString() {
        return FiacrePrinter.toString(this.existing);
    }

    public static CType convert(Type existing) {
        if (existing instanceof BoolType) {
            return CBool.boolType;
        }
        if (existing instanceof IntType) {
            return CInt.intType;
        }
        if (existing instanceof NatType) {
            return CInt.intType;
        }
        if (existing instanceof Interval) {
            return CInt.intType;
        }
        if (existing instanceof Queue) {
            Queue queue = (Queue)existing;
            CExisting subType = new CExisting(queue.getType());
            return new CQueue(subType, TypeUtil.computeArraySizeExpression(queue.getSize()));
        }
        if (existing instanceof Array) {
            Array array = (Array)existing;
            CExisting subType = new CExisting(array.getType());
            return new CArray(subType, TypeUtil.computeArraySizeExpression(array.getSize()));
        }
        if (existing instanceof Record) {
            Record record = (Record)existing;
            CRecord converted = new CRecord();
            for (Field field : record.getFieldList()) {
                converted.addField(field.getName(), new CExisting(field.getType()));
            }
            return converted;
        }
        if (existing instanceof Union) {
            Union union = (Union)existing;
            CUnion converted = new CUnion();
            for (Constr constr : union.getConstrList()) {
                CExisting constrType = constr.getType() == null ? null : new CExisting(constr.getType());
                converted.addConstr(constr.getName(), constrType);
            }
            return converted;
        }
        if (existing instanceof TypeId) {
            return CExisting.convert(((TypeId)existing).getDecl().getIs());
        }
        return null;
    }
}

