/*
 * Decompiled with CFR 0.152.
 */
package spinja.store;

import java.util.Arrays;
import spinja.store.StateStore;
import spinja.store.hash.HashAlgorithm;
import spinja.store.hash.JenkinsHash;

public final class ProbingHashTable
extends StateStore {
    private byte[][] table;
    private int collisions;
    private int stored;
    private int size;
    private int mask;
    private int maxIterations;
    private long bytes;
    private HashAlgorithm hash;
    private ProbingHashTable overflow;

    public ProbingHashTable(int n) {
        this(n, new JenkinsHash());
    }

    public ProbingHashTable(int n, HashAlgorithm hashAlgorithm) {
        this.table = new byte[1 << n][];
        this.stored = 0;
        this.collisions = 0;
        this.size = n;
        this.maxIterations = this.table.length >>> 7;
        this.bytes = 56 + 4 * this.table.length;
        this.hash = hashAlgorithm;
        this.mask = this.table.length - 1;
        this.overflow = null;
    }

    @Override
    public final synchronized int addState(byte[] byArray) {
        return this.addState(byArray, this.hash.hash(byArray));
    }

    private synchronized int addState(byte[] byArray, HashAlgorithm.HashGenerator hashGenerator) {
        int n = hashGenerator.currentHash() & this.mask;
        byte[] byArray2 = this.table[n];
        int n2 = 0;
        while (byArray2 != null) {
            if (Arrays.equals(byArray2, byArray)) {
                return -n - 1;
            }
            if (++n2 > this.maxIterations) {
                if (this.overflow == null) {
                    System.out.println("spinja error: Hashtable too small, adding overflow table.");
                    this.overflow = new ProbingHashTable(this.size, this.hash);
                }
                return this.overflow.addState(byArray, hashGenerator);
            }
            n = hashGenerator.nextHash() & this.mask;
            byArray2 = this.table[n];
        }
        this.table[n] = byArray;
        ++this.stored;
        this.bytes += (long)(19 + byArray.length >> 3 << 3);
        this.collisions += n2;
        return n;
    }

    @Override
    public final synchronized long getBytes() {
        return this.bytes + (this.overflow == null ? 0L : this.overflow.getBytes());
    }

    @Override
    public void printSummary() {
        System.out.printf("hash conflicts: %d (resolved)\n", this.collisions + (this.overflow == null ? 0 : this.overflow.collisions));
        System.out.println();
    }

    @Override
    public final synchronized int getStored() {
        return this.stored;
    }
}

