/*
 * Decompiled with CFR 0.152.
 */
package spinja.promela.model;

import spinja.exceptions.ValidationException;
import spinja.promela.model.PromelaProcess;
import spinja.promela.model.PromelaTransition;
import spinja.promela.model.State;

public abstract class PromelaTransitionFactory {
    private PromelaTransitionFactory next = null;
    protected State state = null;
    private boolean isLocal;
    protected final int transId;
    private final int stateFrom;
    private final int stateTo;
    private final String text;

    public PromelaTransitionFactory(boolean bl, int n, int n2, int n3, String string) {
        this.isLocal = bl;
        this.transId = n;
        this.stateFrom = n2;
        this.stateTo = n3;
        this.text = string;
    }

    public void append(PromelaTransitionFactory promelaTransitionFactory) {
        if (this.next == null) {
            this.next = promelaTransitionFactory;
        } else {
            this.next.append(promelaTransitionFactory);
        }
        promelaTransitionFactory.state = this.state;
    }

    public void setState(State state) {
        this.state = state;
        if (this.next != null) {
            this.next.setState(state);
        }
    }

    public State getState() {
        return this.state;
    }

    public PromelaTransitionFactory getNext() {
        return this.next;
    }

    public PromelaTransitionFactory calcNext() {
        if (this.next == null && this.state.proc._model._exclusive == 255) {
            PromelaProcess promelaProcess = this.state.proc.nextProcess();
            if (promelaProcess != null) {
                return promelaProcess.getCurrentState().getFirst();
            }
            return null;
        }
        return this.next;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isElse() {
        return false;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public int[] getRendezvous() {
        return null;
    }

    public boolean canReadRendezvous(int[] nArray) {
        return false;
    }

    public String toString() {
        return "Holder for: " + this.text;
    }

    public abstract PromelaTransition newTransition();

    public class AtomicTransition
    extends NonAtomicTransition {
        private final boolean takeAtomic;
        private int old_exclusive;

        public AtomicTransition(boolean bl) {
            this.takeAtomic = bl;
        }

        @Override
        public void take() throws ValidationException {
            this.old_exclusive = this.getProcess()._model._exclusive;
            this.takeImpl();
            assert (this.getProcess()._sid == PromelaTransitionFactory.this.stateFrom);
            this.getProcess()._sid = PromelaTransitionFactory.this.stateTo;
            this.getProcess()._model._exclusive = this.takeAtomic ? this.getProcess()._pid : 255;
            this.getProcess().sendTransitionTakenEvent(this);
        }

        @Override
        public void undo() {
            assert (this.getProcess()._sid == PromelaTransitionFactory.this.stateTo);
            this.undoImpl();
            this.getProcess()._model._exclusive = this.old_exclusive;
            this.getProcess()._sid = PromelaTransitionFactory.this.stateFrom;
            this.getProcess().sendTransitionUndoEvent(this);
        }
    }

    public class NonAtomicTransition
    extends PromelaTransition {
        @Override
        public final int getId() {
            return PromelaTransitionFactory.this.transId;
        }

        @Override
        public final PromelaProcess getProcess() {
            return PromelaTransitionFactory.this.state.proc;
        }

        @Override
        public final boolean isEnabled() {
            return PromelaTransitionFactory.this.isEnabled();
        }

        @Override
        public boolean isLocal() {
            return PromelaTransitionFactory.this.isLocal();
        }

        @Override
        public void take() throws ValidationException {
            this.takeImpl();
            assert (this.getProcess()._sid == PromelaTransitionFactory.this.stateFrom);
            this.getProcess()._sid = PromelaTransitionFactory.this.stateTo;
            this.getProcess()._model.sendTransitionTakenEvent(this);
        }

        protected void takeImpl() throws ValidationException {
        }

        public final String toString() {
            return "(proc " + this.getProcess().getId() + " trans " + this.getId() + "): " + PromelaTransitionFactory.this.text;
        }

        @Override
        public void undo() {
            assert (this.getProcess()._sid == PromelaTransitionFactory.this.stateTo);
            this.undoImpl();
            this.getProcess()._sid = PromelaTransitionFactory.this.stateFrom;
            this.getProcess()._model.sendTransitionUndoEvent(this);
        }

        protected void undoImpl() {
        }

        public final PromelaTransitionFactory getHolder() {
            return PromelaTransitionFactory.this;
        }

        @Override
        public PromelaTransitionFactory getFactory() {
            return PromelaTransitionFactory.this;
        }
    }
}

