/*
 * Decompiled with CFR 0.152.
 */
package spinja.promela.model;

import spinja.concurrent.model.Process;
import spinja.promela.model.PromelaModel;
import spinja.promela.model.PromelaTransition;
import spinja.promela.model.PromelaTransitionFactory;
import spinja.promela.model.RendezvousTransition;
import spinja.promela.model.State;

public abstract class PromelaProcess
extends Process<PromelaTransition> {
    protected final PromelaModel _model;
    protected final State[] _stateTable;
    protected int _sid;
    protected final int _pid;
    private final int _nrChannelBefore;

    public PromelaProcess(PromelaModel promelaModel, State[] stateArray, int n) {
        this(promelaModel, stateArray, n, promelaModel._nrProcs);
    }

    public PromelaProcess(PromelaModel promelaModel, State[] stateArray, int n, int n2) {
        this._model = promelaModel;
        this._pid = n2;
        this._stateTable = stateArray;
        this._nrChannelBefore = this._model._nrChannels;
        this._sid = n;
    }

    int getNrChannelsBefore() {
        return this._nrChannelBefore;
    }

    @Override
    public int getId() {
        return this._pid;
    }

    public final State getCurrentState() {
        return this._stateTable[this._sid];
    }

    @Override
    public boolean conditionHolds(int n) {
        switch (n) {
            case 1: {
                return this.getCurrentState().isEndState();
            }
            case 3: {
                return this.getCurrentState().isProgressState();
            }
            case 2: {
                return this.getCurrentState().isAcceptState();
            }
            case 4: {
                return this._model._exclusive == 255;
            }
        }
        return false;
    }

    public boolean isEnabled() {
        return true;
    }

    @Override
    public PromelaProcess clone() {
        try {
            return (PromelaProcess)this.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public PromelaTransition nextTransition(PromelaTransition promelaTransition) {
        if (this._model._exclusive != 255 && this._model._exclusive != this._pid) {
            return null;
        }
        int[] nArray = null;
        PromelaTransitionFactory promelaTransitionFactory = null;
        PromelaTransitionFactory promelaTransitionFactory2 = null;
        if (promelaTransition == null) {
            promelaTransitionFactory2 = this.getCurrentState().getFirst();
        } else if (promelaTransition instanceof RendezvousTransition) {
            RendezvousTransition rendezvousTransition = ((RendezvousTransition)promelaTransition).nextRendezvousTransition();
            if (rendezvousTransition != null) {
                return rendezvousTransition;
            }
            promelaTransitionFactory2 = promelaTransition.getFactory().getNext();
        } else {
            PromelaTransitionFactory promelaTransitionFactory3 = promelaTransitionFactory2 = promelaTransition.getFactory() == null ? null : promelaTransition.getFactory().getNext();
        }
        while (promelaTransitionFactory2 != null) {
            if (promelaTransitionFactory2.isEnabled()) {
                return promelaTransitionFactory2.newTransition();
            }
            nArray = promelaTransitionFactory2.getRendezvous();
            if (nArray != null) {
                for (int i = this._model._nrProcs - 1; i >= 0; --i) {
                    PromelaProcess promelaProcess = this._model._procs[i];
                    if (promelaProcess == this) continue;
                    for (PromelaTransitionFactory promelaTransitionFactory4 = promelaProcess.getCurrentState().getFirst(); promelaTransitionFactory4 != null; promelaTransitionFactory4 = promelaTransitionFactory4.getNext()) {
                        if (!promelaTransitionFactory4.canReadRendezvous(nArray)) continue;
                        return new RendezvousTransition(this._model, promelaTransitionFactory2.newTransition(), promelaTransitionFactory4.newTransition());
                    }
                }
            } else if (promelaTransition == null && promelaTransitionFactory2.isElse()) {
                promelaTransitionFactory = promelaTransitionFactory2;
            }
            promelaTransitionFactory2 = promelaTransitionFactory2.getNext();
        }
        if (promelaTransitionFactory != null) {
            return promelaTransitionFactory.newTransition();
        }
        if (this._model._exclusive == this._pid && promelaTransition == null) {
            return this._model.newEndAtomic();
        }
        return null;
    }

    public PromelaProcess prevProcess() {
        if (this._pid > 0) {
            return this._model._procs[this._pid - 1];
        }
        return null;
    }

    public PromelaProcess nextProcess() {
        if (this._pid + 1 < this._model._nrProcs) {
            return this._model._procs[this._pid + 1];
        }
        return null;
    }

    public PromelaModel getModel() {
        return this._model;
    }

    @Override
    public boolean onlyLocalTransitions() {
        for (PromelaTransitionFactory promelaTransitionFactory = this.getCurrentState().getFirst(); promelaTransitionFactory != null; promelaTransitionFactory = promelaTransitionFactory.getNext()) {
            if (promelaTransitionFactory.isLocal()) continue;
            return false;
        }
        return true;
    }
}

