/*
 * Decompiled with CFR 0.152.
 */
package obp.literal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import obp.literal.Literal;
import obp.literal.LiteralVisitor;
import org.xid.basics.serializer.Boost;
import org.xid.basics.serializer.BoostObject;
import org.xid.basics.serializer.BoostUtil;

public class ArrayLiteral
extends Literal
implements BoostObject {
    private String typeName;
    private final List<Literal> valueList = new ArrayList<Literal>();

    public ArrayLiteral() {
    }

    protected ArrayLiteral(Boost boost) {
        super(boost);
        this.typeName = boost.readString();
        for (Literal oneChild : BoostUtil.readObjectList((Boost)boost, Literal.class)) {
            this.valueList.add(oneChild);
        }
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String newValue) {
        if (this.typeName == null ? newValue != null : !this.typeName.equals(newValue)) {
            this.typeName = newValue;
        }
    }

    public List<Literal> getValueList() {
        return Collections.unmodifiableList(this.valueList);
    }

    public int getValueCount() {
        return this.valueList.size();
    }

    public Literal getValue(int index) {
        if (index < 0 || index >= this.getValueCount()) {
            return null;
        }
        return this.valueList.get(index);
    }

    public void addValue(Literal newValue) {
        this.addValue(this.getValueCount(), newValue);
    }

    public void addValue(int index, Literal newValue) {
        this.valueList.add(index, newValue);
    }

    public Literal setValue(int index, Literal newValue) {
        return this.valueList.set(index, newValue);
    }

    public void addAllValue(Collection<Literal> toAddList) {
        for (Literal newValue : toAddList) {
            this.addValue(this.getValueCount(), newValue);
        }
    }

    public void removeValue(Literal value) {
        int index = this.valueList.indexOf(value);
        if (index >= 0) {
            this.removeValue(index);
        }
    }

    public void removeValue(int index) {
        this.valueList.remove(index);
    }

    @Override
    public void writeToBoost(Boost boost) {
        super.writeToBoost(boost);
        boost.writeString(this.typeName);
        BoostUtil.writeObjectCollection((Boost)boost, this.valueList);
    }

    @Override
    public void accept(LiteralVisitor visitor) {
        visitor.visitArrayLiteral(this);
    }
}

