/*
 * Decompiled with CFR 0.152.
 */
package org.petitparser.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.petitparser.parser.Parser;

public class Mirror
implements Iterable<Parser> {
    private final Parser parser;

    public static Mirror of(Parser parser) {
        return new Mirror(parser);
    }

    private Mirror(Parser parser) {
        this.parser = Objects.requireNonNull(parser, "Undefined parser");
    }

    public String toString() {
        return this.getClass().getSimpleName() + " of " + this.parser.toString();
    }

    @Override
    public Iterator<Parser> iterator() {
        return new ParserIterator(this.parser);
    }

    public Stream<Parser> stream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(), 257), false);
    }

    public Parser transform(Function<Parser, Parser> transformer) {
        HashMap<Parser, Parser> mapping = new HashMap<Parser, Parser>();
        for (Parser parser : this) {
            mapping.put(parser, transformer.apply(parser.copy()));
        }
        HashSet seen = new HashSet(mapping.values());
        ArrayList todo = new ArrayList(mapping.values());
        while (!todo.isEmpty()) {
            Parser parent = (Parser)todo.remove(todo.size() - 1);
            for (Parser child : parent.getChildren()) {
                if (mapping.containsKey(child)) {
                    parent.replace(child, (Parser)mapping.get(child));
                    continue;
                }
                if (seen.contains(child)) continue;
                seen.add(child);
                todo.add(child);
            }
        }
        return (Parser)mapping.get(this.parser);
    }

    private static class ParserIterator
    implements Iterator<Parser> {
        private final List<Parser> todo = new ArrayList<Parser>();
        private final Set<Parser> seen = new HashSet<Parser>();

        private ParserIterator(Parser root) {
            this.todo.add(root);
            this.seen.add(root);
        }

        @Override
        public boolean hasNext() {
            return !this.todo.isEmpty();
        }

        @Override
        public Parser next() {
            if (this.todo.isEmpty()) {
                throw new NoSuchElementException();
            }
            Parser current = this.todo.remove(this.todo.size() - 1);
            for (Parser parser : current.getChildren()) {
                if (this.seen.contains(parser)) continue;
                this.todo.add(parser);
                this.seen.add(parser);
            }
            return current;
        }
    }
}

