/*
 * Decompiled with CFR 0.152.
 */
package spinja.promela.compiler.expression;

import java.util.HashSet;
import java.util.Set;
import spinja.promela.compiler.expression.Expression;
import spinja.promela.compiler.parser.ParseException;
import spinja.promela.compiler.parser.Token;
import spinja.promela.compiler.variable.Variable;
import spinja.promela.compiler.variable.VariableAccess;
import spinja.promela.compiler.variable.VariableType;

public class Identifier
extends Expression {
    private static final long serialVersionUID = -5928789117017713005L;
    private Variable var = null;
    private Expression arrayExpr = null;

    public Identifier(Token token, Variable variable) {
        super(token);
        this.var = variable;
        this.arrayExpr = null;
    }

    public Identifier(Token token, Variable variable, Expression expression) {
        super(token);
        this.var = variable;
        this.arrayExpr = expression;
    }

    public Expression getArrayExpr() {
        return this.arrayExpr;
    }

    @Override
    public String getIntExpression() throws ParseException {
        if (this.var.getArraySize() > 1) {
            if (this.arrayExpr != null) {
                return this.var.getName() + "[" + this.arrayExpr.getIntExpression() + "]";
            }
            return this.var.getName() + "[0]";
        }
        return this.var.getName();
    }

    @Override
    public VariableType getResultType() throws ParseException {
        return this.var.getType();
    }

    @Override
    public String getSideEffect() throws ParseException {
        if (this.arrayExpr != null) {
            return this.arrayExpr.getSideEffect();
        }
        return null;
    }

    public Variable getVariable() {
        return this.var;
    }

    @Override
    public Set<VariableAccess> readVariables() {
        HashSet<VariableAccess> hashSet = new HashSet<VariableAccess>();
        hashSet.add(new VariableAccess(this.var, this.arrayExpr));
        return hashSet;
    }

    @Override
    public String toString() {
        if (this.var.getArraySize() > 1) {
            if (this.arrayExpr != null) {
                return this.var.getName() + "[" + this.arrayExpr.toString() + "]";
            }
            return this.var.getName() + "[0]";
        }
        return this.var.getName();
    }
}

