/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.ffi.try1;

import c.builder.CBuilder;
import c.model.Expression;
import c.model.FunctionCall;
import c.model.StatementGroup;
import c.model.StructureDereference;
import c.model.StructureReference;
import c.model.UnaryExpression;
import c.model.VariableDeclaration;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import obp.fiacre.ffi.try1.FFIBindingGenerator;
import obp.fiacre.model.Array;
import obp.fiacre.model.ArrayedType;
import obp.fiacre.model.BoolType;
import obp.fiacre.model.Field;
import obp.fiacre.model.IntType;
import obp.fiacre.model.Interval;
import obp.fiacre.model.ModelVisitor;
import obp.fiacre.model.NatType;
import obp.fiacre.model.Queue;
import obp.fiacre.model.Record;
import obp.fiacre.model.Type;
import obp.fiacre.model.TypeDecl;
import obp.fiacre.model.TypeId;
import obp.fiacre.model.Union;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class TC2FiacreUnmarshaller
extends ModelVisitor.Stub {
    FFIBindingGenerator client;
    StatementGroup unmarshallStmts;
    CBuilder cBuilder;
    Map<Object, VariableDeclaration> valueMap = new HashMap<Object, VariableDeclaration>();
    Map<String, VariableDeclaration> absoluteName2index = new HashMap<String, VariableDeclaration>();
    Map<String, VariableDeclaration> absoluteName2object = new HashMap<String, VariableDeclaration>();
    Stack<String> absoluteNameStack = new Stack();
    Stack<VariableDeclaration> objectContext = new Stack();
    Stack<VariableDeclaration> indexContext = new Stack();
    Stack<Expression> valueContext = new Stack();
    Stack<Object> fcrContext = new Stack();

    public TC2FiacreUnmarshaller(FFIBindingGenerator client, StatementGroup unmarshallStmts) {
        this.client = client;
        this.unmarshallStmts = unmarshallStmts;
        this.cBuilder = client.cBuilder;
    }

    FunctionCall createJniCall(String memberName) {
        UnaryExpression envP = this.cBuilder.dereference(this.client.referenceTo("env", this.unmarshallStmts));
        StructureDereference fctMember = this.cBuilder.dereference(envP, memberName);
        FunctionCall fCall = this.cBuilder.functionCall(fctMember);
        fCall.getArguments().add(this.client.referenceTo("env", this.unmarshallStmts));
        return fCall;
    }

    private String getAbsoluteName() {
        String result = "";
        for (String s : this.absoluteNameStack) {
            result = result + s + ".";
        }
        return result;
    }

    public void unmarshallPrimitiveType(Type toVisit, String type) {
        this.absoluteNameStack.push(type);
        if (this.inArrayContext() == null) {
            FunctionCall sbfCall = this.createJniCall("Set" + type + "Field");
            sbfCall.getArguments().add(this.cBuilder.reference(this.objectContext.peek()));
            sbfCall.getArguments().add(this.cBuilder.reference(this.indexContext.peek()));
            if (this.valueContext.size() > 0) {
                sbfCall.getArguments().add(this.valueContext.peek());
            } else {
                sbfCall.getArguments().add(this.cBuilder.reference(this.valueMap.get(toVisit)));
            }
            this.unmarshallStmts.getStatements().add(sbfCall);
        }
        this.absoluteNameStack.pop();
    }

    @Override
    public void visitBoolType(BoolType toVisit) {
        this.unmarshallPrimitiveType(toVisit, "Boolean");
    }

    private void marshalInt(Type toVisit) {
        this.unmarshallPrimitiveType(toVisit, "Int");
    }

    @Override
    public void visitIntType(IntType toVisit) {
        this.marshalInt(toVisit);
    }

    @Override
    public void visitNatType(NatType toVisit) {
        this.marshalInt(toVisit);
    }

    @Override
    public void visitInterval(Interval toVisit) {
        this.marshalInt(toVisit);
    }

    @Override
    public void visitField(Field toVisit) {
        this.absoluteNameStack.push(toVisit.getName());
        this.indexContext.push(this.absoluteName2index.get(this.getAbsoluteName()));
        StructureReference strA = this.cBuilder.reference((Expression)EcoreUtil.copy((EObject)this.valueContext.peek()), toVisit.getName());
        this.valueContext.push(strA);
        toVisit.getType().accept(this);
        this.valueContext.pop();
        this.indexContext.pop();
        this.absoluteNameStack.pop();
    }

    @Override
    public void visitRecord(Record toVisit) {
        this.fcrContext.push(toVisit);
        this.absoluteNameStack.push("rec");
        this.objectContext.push(this.absoluteName2object.get(this.getAbsoluteName()));
        Expression exp = (Expression)EcoreUtil.copy((EObject)this.valueContext.peek());
        for (Field field : toVisit.getFieldList()) {
            this.valueContext.push(exp);
            field.accept(this);
            this.valueContext.pop();
        }
        this.objectContext.pop();
        this.absoluteNameStack.pop();
        this.fcrContext.pop();
    }

    private void unmarshalArrayedType(ArrayedType toVisit) {
        this.fcrContext.push(toVisit);
        toVisit.getType().accept(this);
        this.fcrContext.pop();
    }

    @Override
    public void visitArray(Array toVisit) {
        this.unmarshalArrayedType(toVisit);
    }

    @Override
    public void visitUnion(Union toVisit) {
    }

    @Override
    public void visitQueue(Queue toVisit) {
        this.unmarshalArrayedType(toVisit);
    }

    @Override
    public void visitTypeId(TypeId toVisit) {
        this.fcrContext.push(toVisit);
        toVisit.getDecl().accept(this);
        this.fcrContext.pop();
    }

    @Override
    public void visitTypeDecl(TypeDecl toVisit) {
        this.fcrContext.push(toVisit);
        this.absoluteNameStack.push(toVisit.getName());
        toVisit.getIs().accept(this);
        this.absoluteNameStack.pop();
        this.fcrContext.pop();
    }

    public ArrayedType inArrayContext() {
        if (this.fcrContext.size() < 1) {
            return null;
        }
        if (this.fcrContext.peek() instanceof ArrayedType) {
            return (ArrayedType)this.fcrContext.peek();
        }
        if (this.fcrContext.size() < 3) {
            return null;
        }
        if (this.fcrContext.peek() instanceof TypeDecl && this.fcrContext.get(this.fcrContext.size() - 3) instanceof ArrayedType) {
            return (ArrayedType)this.fcrContext.get(this.fcrContext.size() - 3);
        }
        return null;
    }

    public boolean isArray(Type type) {
        if (type instanceof BoolType || type instanceof IntType || type instanceof NatType || type instanceof Interval) {
            return false;
        }
        if (type instanceof TypeId) {
            return this.isArray(((TypeId)type).getDecl().getIs());
        }
        return type instanceof Array;
    }
}

