/*
 * Decompiled with CFR 0.152.
 */
package org.xid.basics.generation;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.xid.basics.generation.MergerUtil;

public interface Merger {
    public static final Merger DEFAULT = new Stub();

    public void merge(File var1, String var2, String var3) throws Exception;

    public List<File> mergedFileList();

    public static class Stub
    implements Merger {
        private final List<File> fileList = new ArrayList<File>();

        @Override
        public void merge(File destinationFile, String contents, String encoding) throws Exception {
            if (!destinationFile.exists() || !MergerUtil.checkContents(destinationFile, contents, encoding)) {
                MergerUtil.writeFile(destinationFile, contents, encoding);
            }
            this.fileList.add(destinationFile);
        }

        @Override
        public List<File> mergedFileList() {
            return this.fileList;
        }
    }
}

