/*
 * Decompiled with CFR 0.152.
 */
package obp.explorer.runtime.ccsl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class CCSLConfigurationGraph {
    private static Map<Integer, String> sTrans = new HashMap<Integer, String>();
    private static Map<Integer, Map<Integer, String>> sConfigurationGraph;
    private List<String> states = Arrays.asList("s0", "s1");
    private Map<Integer, Map<Integer, String>> configurationGraph = sConfigurationGraph;

    public CCSLConfigurationGraph() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CCSLConfigurationGraph(File ccslFile) {
        BufferedReader reader = null;
        try {
            int i;
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(ccslFile)));
            String sizes = reader.readLine();
            StringTokenizer sT = new StringTokenizer(sizes);
            assert (sT.countTokens() == 2);
            int nbStates = Integer.parseInt(sT.nextToken());
            int nbTransitions = Integer.parseInt(sT.nextToken());
            this.states = new ArrayList<String>(nbStates);
            String statesLine = reader.readLine();
            sT = new StringTokenizer(statesLine);
            assert (sT.countTokens() == nbStates);
            for (i = 0; i < nbStates; ++i) {
                this.states.add(sT.nextToken());
            }
            this.configurationGraph = new HashMap<Integer, Map<Integer, String>>(nbStates);
            for (i = 0; i < nbTransitions; ++i) {
                String transLine = reader.readLine();
                sT = new StringTokenizer(transLine);
                assert (sT.countTokens() == 3);
                int from = Integer.parseInt(sT.nextToken());
                String sync = null;
                if (sT.countTokens() == 2) {
                    sync = sT.nextToken();
                }
                int to = Integer.parseInt(sT.nextToken());
                Map<Integer, String> fanout = this.configurationGraph.get(from);
                if (fanout == null) {
                    fanout = new HashMap<Integer, String>();
                    this.configurationGraph.put(from, fanout);
                }
                fanout.put(to, sync);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    List<String> getStates() {
        return Collections.unmodifiableList(this.states);
    }

    int getStateId(String state) {
        return this.states.indexOf(state);
    }

    int getStateCount() {
        return this.states.size();
    }

    int getTransitionCount() {
        int sum = 0;
        for (Map<Integer, String> m : this.configurationGraph.values()) {
            sum += m.size();
        }
        return sum;
    }

    Map<Integer, String> getFanout(int state) {
        Map<Integer, String> trans = this.configurationGraph.get(state);
        if (trans == null) {
            return Collections.emptyMap();
        }
        return trans;
    }

    static {
        sTrans.put(1, "{system}1:abc");
        sConfigurationGraph = new HashMap<Integer, Map<Integer, String>>();
        sConfigurationGraph.put(0, sTrans);
    }
}

