/*
 * Decompiled with CFR 0.152.
 */
package plug.language.SpinJa.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import plug.core.IConcurrentTransitionRelation;
import plug.core.IFiredTransition;
import plug.language.SpinJa.runtime.SpinJaConfiguration;
import plug.language.SpinJa.runtime.SpinJaExplorationContext;
import plug.statespace.transitions.FiredTransition;
import plug.utils.Pair;
import spinja.concurrent.model.ConcurrentModel;
import spinja.exceptions.SpinJaException;
import spinja.promela.model.PromelaTransition;
import spinja.search.TransitionCalculator;
import spinja.util.ByteArrayStorage;
import spinja.util.DataReader;
import spinja.util.DataWriter;

public class SpinJaTransitionRelation
implements IConcurrentTransitionRelation<SpinJaTransitionRelation, SpinJaConfiguration, Pair<PromelaTransition, SpinJaConfiguration>> {
    SpinJaExplorationContext context;
    ConcurrentModel<PromelaTransition> model;
    TransitionCalculator<ConcurrentModel<PromelaTransition>, PromelaTransition> nextTransition = new TransitionCalculator();
    protected final ByteArrayStorage storage = new ByteArrayStorage();

    public ConcurrentModel<PromelaTransition> getModel() {
        return this.model;
    }

    public void setModel(SpinJaExplorationContext context) {
        this.context = context;
        this.model = context.theModel;
    }

    protected byte[] storeModel() {
        this.storage.init(this.model.getSize());
        this.model.encode((DataWriter)this.storage);
        return this.storage.getBuffer();
    }

    public SpinJaTransitionRelation createCopy() {
        SpinJaTransitionRelation copy = new SpinJaTransitionRelation();
        copy.model = (ConcurrentModel)this.model.clone();
        if (copy.model == null) {
            throw new RuntimeException();
        }
        return copy;
    }

    public Set<SpinJaConfiguration> initialConfigurations() {
        SpinJaConfiguration initial = new SpinJaConfiguration();
        initial.state = this.storeModel();
        return Collections.singleton(initial);
    }

    public List<Pair<PromelaTransition, SpinJaConfiguration>> fireableTransitionsFrom(SpinJaConfiguration configuration) {
        PromelaTransition next;
        SpinJaConfiguration current = configuration;
        ByteArrayStorage reader = new ByteArrayStorage();
        reader.setBuffer(current.state);
        this.model.decode((DataReader)reader);
        ArrayList<Pair<PromelaTransition, SpinJaConfiguration>> fireables = new ArrayList<Pair<PromelaTransition, SpinJaConfiguration>>();
        PromelaTransition last = null;
        while ((next = (PromelaTransition)this.nextTransition.next(this.model, last)) != null) {
            try {
                next.take();
            }
            catch (SpinJaException ex) {
                System.out.println("Transition error " + ex.getMessage());
                return Collections.emptyList();
            }
            if (this.model.conditionHolds(4)) {
                SpinJaConfiguration nextConfig = new SpinJaConfiguration();
                nextConfig.state = this.storeModel();
                fireables.add((Pair<PromelaTransition, SpinJaConfiguration>)new Pair((Object)next, (Object)nextConfig));
                next.undo();
            }
            last = next;
        }
        return fireables;
    }

    public IFiredTransition<SpinJaConfiguration, ?> fireOneTransition(SpinJaConfiguration source, Pair<PromelaTransition, SpinJaConfiguration> transition) {
        return new FiredTransition((Object)source, transition.b, transition.a);
    }
}

