/*
 * Decompiled with CFR 0.152.
 */
package org.cte.ABCD.transformations.fiacre;

import java.util.LinkedHashMap;
import java.util.Map;
import obp.fiacre.model.Foreach;
import obp.fiacre.model.IfStmt;
import obp.fiacre.model.ModelVisitor;
import obp.fiacre.model.ProcessDecl;
import obp.fiacre.model.Select;
import obp.fiacre.model.Seq;
import obp.fiacre.model.Statement;
import obp.fiacre.model.Transition;
import obp.fiacre.model.WhileStmt;

class StatementReplacer
extends ModelVisitor.Stub {
    private Map<Statement, Statement> replacementMap = new LinkedHashMap<Statement, Statement>();

    StatementReplacer() {
    }

    private Statement hasReplacement(Statement s) {
        return this.replacementMap.get(s);
    }

    public void addChange(Statement source, Statement dest) {
        this.replacementMap.put(source, dest);
    }

    @Override
    public void visitProcessDecl(ProcessDecl toVisit) {
        for (Transition t : toVisit.getTransitionList()) {
            t.accept(this);
        }
    }

    @Override
    public void visitTransition(Transition toVisit) {
        toVisit.getAction().accept(this);
    }

    @Override
    public void visitSeq(Seq toVisit) {
        for (int i = 0; i < toVisit.getStatementCount(); ++i) {
            Statement child = toVisit.getStatement(i);
            Statement toReplace = this.hasReplacement(child);
            if (toReplace == null) {
                child.accept(this);
                continue;
            }
            toVisit.setStatement(i, toReplace);
        }
    }

    @Override
    public void visitForeach(Foreach toVisit) {
        Statement toReplace = this.hasReplacement(toVisit.getBody());
        if (toReplace == null) {
            toVisit.getBody().accept(this);
        } else {
            toVisit.setBody(toReplace);
        }
    }

    @Override
    public void visitIfStmt(IfStmt toVisit) {
        Statement toReplace = this.hasReplacement(toVisit.getThen());
        if (toReplace == null) {
            toVisit.getThen().accept(this);
        } else {
            toVisit.setThen(toReplace);
        }
        toReplace = this.hasReplacement(toVisit.getElse());
        if (toReplace == null) {
            toVisit.getElse().accept(this);
        } else {
            toVisit.setElse(toReplace);
        }
    }

    @Override
    public void visitSelect(Select toVisit) {
        for (int i = 0; i < toVisit.getStatementCount(); ++i) {
            Statement child = toVisit.getStatement(i);
            Statement toReplace = this.hasReplacement(child);
            if (toReplace == null) {
                child.accept(this);
                continue;
            }
            toVisit.setStatement(i, toReplace);
        }
    }

    @Override
    public void visitWhileStmt(WhileStmt toVisit) {
        Statement toReplace = this.hasReplacement(toVisit.getBody());
        if (toReplace == null) {
            toVisit.getBody().accept(this);
        } else {
            toVisit.setBody(toReplace);
        }
    }
}

