/*
 * Decompiled with CFR 0.152.
 */
package obp.ui.explorer;

import java.util.ArrayList;
import obp.explorer.ConfsFileHandler;
import obp.explorer.runtime.Configuration;
import obp.explorer.runtime.evaluator.Tester;
import obp.ui.explorer.ConfsFileHandlerController;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.xid.basics.error.Diagnostic;
import org.xid.basics.error.Validator;
import org.xid.basics.notification.Notification;
import org.xid.basics.notification.NotificationListener;
import org.xid.basics.progress.ActionMonitor;
import org.xid.basics.ui.action.Action;
import org.xid.basics.ui.dialog.FieldShellToolkit;
import org.xid.basics.ui.field.CompositeField;
import org.xid.basics.ui.field.Field;
import org.xid.basics.ui.field.ListField;
import org.xid.basics.ui.field.TextField;

public class SearchConfigurationsAction
extends Action.Stub {
    private final ConfsFileHandlerController parent;
    private TextField predicateField;
    private ListField<Integer> filteredListField;
    private FieldShellToolkit toolkit;
    private String predicateErrorMessage;
    private boolean loading = false;

    public SearchConfigurationsAction(ConfsFileHandlerController parent) {
        super("Search");
        this.parent = parent;
    }

    public int getVisibility() {
        if (this.parent.getSubject() == null) {
            return 2;
        }
        return this.loading ? 4 : 1;
    }

    public int run(ActionMonitor monitor) {
        final ConfsFileHandler confs = (ConfsFileHandler)this.parent.getSubject();
        if (confs == null) {
            return 3;
        }
        this.loading = true;
        Thread loader = new Thread(new Runnable(){

            @Override
            public void run() {
                confs.readAll();
                SearchConfigurationsAction.this.loading = false;
                SearchConfigurationsAction.this.openSearchDialog();
            }
        });
        loader.start();
        return 1;
    }

    private Tester createTester() {
        this.predicateErrorMessage = null;
        ConfsFileHandler confs = (ConfsFileHandler)this.parent.getSubject();
        if (confs == null) {
            this.predicateErrorMessage = "No configuration to filter.";
            return null;
        }
        String predicateString = this.predicateField.getValue();
        if (predicateString == null) {
            this.predicateErrorMessage = "No predicate to search for.";
            return null;
        }
        try {
            return confs.createTester(predicateString);
        }
        catch (NullPointerException e) {
            this.predicateErrorMessage = "Invalid predicate";
            return null;
        }
        catch (Exception e) {
            this.predicateErrorMessage = e.getMessage();
            return null;
        }
    }

    private void openSearchDialog() {
        this.predicateField = new TextField(null, 4);
        this.predicateField.setValidator((Validator)new Validator<String>(){

            public boolean isValid(String value) {
                return SearchConfigurationsAction.this.createTester() != null;
            }

            public Diagnostic getDiagnostic() {
                return new Diagnostic.Stub(2, SearchConfigurationsAction.this.predicateErrorMessage);
            }
        });
        this.filteredListField = new ListField<Integer>(null, 2){

            public String getText(Integer element) {
                return Integer.toString(element);
            }
        };
        this.predicateField.addListener(new NotificationListener(){

            public void notified(Notification notification) {
                SearchConfigurationsAction.this.filteredListField.setValue(null);
                Tester tester = SearchConfigurationsAction.this.createTester();
                if (tester == null) {
                    return;
                }
                ConfsFileHandler confs = (ConfsFileHandler)SearchConfigurationsAction.this.parent.getSubject();
                ArrayList<Configuration> filtered = new ArrayList<Configuration>();
                int count = confs.readAll();
                try {
                    for (int i = 0; i < count; ++i) {
                        Configuration configuration = confs.getConfiguration(i);
                        if (!tester.test(configuration)) continue;
                        filtered.add(configuration);
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    SearchConfigurationsAction.this.parent.getErrorHandler().handleError(2, "Out of bound array access (in predicate '" + SearchConfigurationsAction.this.predicateField.getValue() + "').\n");
                }
                catch (NullPointerException e) {
                    SearchConfigurationsAction.this.parent.getErrorHandler().handleError(2, "Null value access (in predicate '" + SearchConfigurationsAction.this.predicateField.getValue() + "').\n");
                }
                catch (ClassCastException e) {
                    SearchConfigurationsAction.this.parent.getErrorHandler().handleError(2, "Type error (in predicate '" + SearchConfigurationsAction.this.predicateField.getValue() + "', internal message '" + e.getMessage() + "').\n");
                }
                ArrayList<Integer> fl = new ArrayList<Integer>(filtered.size());
                for (int i = 0; i < filtered.size(); ++i) {
                    fl.add(((Configuration)filtered.get((int)i)).id);
                }
                SearchConfigurationsAction.this.filteredListField.setValue(fl);
                SearchConfigurationsAction.this.toolkit.setInitialMessage(filtered.size() + " configurations satifies predicate.");
            }
        });
        final Display display = Display.getDefault();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = FieldShellToolkit.createShell((Display)display, (String)"OBP: Search");
                SearchConfigurationsAction.this.toolkit = new FieldShellToolkit(shell, "Search Configuration", 0, (Field)new CompositeField(new Field[]{SearchConfigurationsAction.this.predicateField, SearchConfigurationsAction.this.filteredListField}));
                SearchConfigurationsAction.this.toolkit.init();
                shell.open();
            }
        });
    }
}

