/*
 * Decompiled with CFR 0.152.
 */
package obp.ui.cdl.diagram;

import obp.cdl.Activity;
import obp.cdl.SeqActivity;
import obp.ui.cdl.diagram.ActivityElement;
import obp.ui.cdl.diagram.CDLDiagram;
import org.xid.basics.geometry.Geometry;
import org.xid.basics.ui.diagram.DiagramContext;
import org.xid.basics.ui.diagram.gc.GC;
import org.xid.basics.ui.diagram.gc.GcUtils;

public class SeqActivityElement
extends ActivityElement {
    private final SeqActivity model;
    private final int occurences;

    public SeqActivityElement(SeqActivity model, int occurences, boolean rejoin, float[] northPoint) {
        super(rejoin, northPoint);
        this.model = model;
        this.occurences = occurences;
    }

    @Override
    public void buildChildren(CDLDiagram diagram) {
        float[] refPoint = Geometry.copyPoints((float[])this.northPoint);
        refPoint[1] = refPoint[1] + 25.0f;
        for (int i = 0; i < this.model.getActivityCount(); ++i) {
            boolean last;
            Activity child = this.model.getActivity(i);
            ActivityElement element = SeqActivityElement.createElement(diagram, child, (last = i == this.model.getActivityCount() - 1) || this.rejoin, refPoint);
            if (element == null) continue;
            this.children.add(element);
            float[] elementSize = element.getSize();
            refPoint[1] = refPoint[1] + (elementSize[1] + 50.0f);
            this.size[0] = Math.max(this.size[0], elementSize[0]);
            this.size[1] = this.size[1] + (elementSize[1] + 50.0f);
        }
    }

    @Override
    public void moveNorthPoint(float dx, float dy) {
        super.moveNorthPoint(dx, dy);
        for (ActivityElement child : this.children) {
            child.moveNorthPoint(dx, dy);
        }
    }

    @Override
    public void display(GC gc, DiagramContext context) {
        ActivityElement last = null;
        for (ActivityElement child : this.children) {
            if (last != null) {
                GcUtils.drawLine((GC)gc, (float)last.northPoint[0], (float)(last.northPoint[1] + last.size[1]), (float)child.northPoint[0], (float)child.northPoint[1]);
            } else {
                GcUtils.drawLine((GC)gc, (float)this.northPoint[0], (float)this.northPoint[1], (float)child.northPoint[0], (float)child.northPoint[1]);
            }
            context.getDiagram().resetGc(gc, context);
            child.display(gc, context);
            context.getDiagram().resetGc(gc, context);
            last = child;
        }
        if (last != null) {
            if (!(last instanceof ActivityElement) || last.rejoin) {
                GcUtils.drawLine((GC)gc, (float)last.northPoint[0], (float)(last.northPoint[1] + last.size[1]), (float)this.northPoint[0], (float)(this.northPoint[1] + this.size[1]));
            }
        } else {
            GcUtils.drawLine((GC)gc, (float)this.northPoint[0], (float)this.northPoint[1], (float)this.northPoint[0], (float)(this.northPoint[1] + this.size[1]));
        }
        if (this.occurences > 1) {
            this.displayFrame(gc, context, null, this.occurences);
        }
        super.display(gc, context);
    }

    @Override
    public SeqActivity getModel() {
        return this.model;
    }
}

