/*
 * Decompiled with CFR 0.152.
 */
package obp.abcd;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.cte.ABCD.fiacre.ABCDUtil;

public class ABCDCompiler {
    File abcdPath = null;
    File outputPath = null;

    public void compile() throws IOException {
        String fiacre = ABCDUtil.toFiacre(this.abcdPath);
        if (this.outputPath == null) {
            String newName = this.abcdPath.getName().replaceAll("[.-]", "_");
            this.outputPath = new File(this.abcdPath.getParentFile(), newName + ".fcr");
        }
        this.outputPath.getAbsoluteFile().getParentFile().mkdirs();
        this.outputPath.createNewFile();
        BufferedWriter os = new BufferedWriter(new FileWriter(this.outputPath));
        os.write(fiacre);
        os.close();
    }

    private void usage() {
        System.out.println("Usage: ABCDCompiler <abcd-file-path> [-o output-path]");
        System.out.println("Optional parameters: ");
        System.out.println("\t[--output or -o] path\toutput file.");
        System.out.println();
        System.out.println("Other parameters:");
        System.out.println("\t[--help or -h]\t\t\tPrints this help and exit.");
    }

    public boolean readArguments(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if ("--help".equals(args[i]) || "-h".equals(args[i])) {
                this.usage();
                return false;
            }
            if ("--output".equals(args[i]) || "-o".equals(args[i])) {
                if (++i == args.length) {
                    System.err.println("Option '--output' needs an argument.");
                    return false;
                }
                this.outputPath = new File(args[i]);
                continue;
            }
            this.abcdPath = new File(args[i]);
        }
        if (this.abcdPath == null) {
            System.err.println("missing path to the ABCD file");
            this.usage();
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        ABCDCompiler main = new ABCDCompiler();
        try {
            if (main.readArguments(args)) {
                main.compile();
                System.exit(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(1);
    }
}

