/*
 * Decompiled with CFR 0.152.
 */
package DVE.compiler;

import DVE.compiler.builder.DVEBuilder;
import DVE.grammar.DVEBaseListener;
import DVE.grammar.DVEParser;
import DVE.model.Assignment;
import DVE.model.BinaryOperator;
import DVE.model.ChannelDeclaration;
import DVE.model.CompositeDeclaration;
import DVE.model.Element;
import DVE.model.Expression;
import DVE.model.InputSynchronization;
import DVE.model.Literal;
import DVE.model.ModelFactory;
import DVE.model.OutputSynchronization;
import DVE.model.Process;
import DVE.model.ProcessReference;
import DVE.model.ProcessStateReference;
import DVE.model.ProcessVariableReference;
import DVE.model.State;
import DVE.model.StateReference;
import DVE.model.System;
import DVE.model.SystemProperties;
import DVE.model.SystemType;
import DVE.model.Transition;
import DVE.model.Type;
import DVE.model.TypedChannelDeclaration;
import DVE.model.UnaryOperator;
import DVE.model.VariableDeclaration;
import DVE.model.VariableReference;
import java.util.Arrays;
import java.util.Stack;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class DVEASTBuilder
extends DVEBaseListener {
    ModelFactory dveFactory = ModelFactory.eINSTANCE;
    DVEBuilder builder = new DVEBuilder();
    Stack<Element> declarationContext = new Stack();
    Stack<Element> context = new Stack();
    Stack<Expression> exprStack = new Stack();
    System system;

    public void pushContext(Element node) {
        this.declarationContext.push(node);
    }

    public <T extends Element> T popContext(Class<T> type) {
        if (this.declarationContext.size() < 1) {
            return null;
        }
        Element decl = this.declarationContext.pop();
        if (type.isAssignableFrom(decl.getClass())) {
            return (T)((Element)type.cast(decl));
        }
        return null;
    }

    private <T extends Element> T peekContext(Class<T> type) {
        if (this.declarationContext.size() < 1) {
            return null;
        }
        Element decl = this.declarationContext.peek();
        if (type.isAssignableFrom(decl.getClass())) {
            return (T)((Element)type.cast(decl));
        }
        return null;
    }

    private void reportError(String description) {
        throw new Error("ASTBuiler:" + description);
    }

    private <T extends Element> T node(Class<T> type) {
        if (this.context.size() < 1) {
            return null;
        }
        Element decl = this.context.peek();
        if (type.isAssignableFrom(decl.getClass())) {
            return (T)((Element)type.cast(decl));
        }
        return null;
    }

    @Override
    public void enterVariableDecl(DVEParser.VariableDeclContext ctx) {
        if (ctx.CONST() != null) {
            this.context.push(this.dveFactory.createConstantDeclaration());
            return;
        }
        this.context.push(this.dveFactory.createVariableDeclaration());
    }

    @Override
    public void exitVariableDecl(DVEParser.VariableDeclContext ctx) {
        this.context.pop();
    }

    @Override
    public void enterChannelDecl(DVEParser.ChannelDeclContext ctx) {
        if (ctx.typeList() == null) {
            this.context.push(this.dveFactory.createChannelDeclaration());
            return;
        }
        this.context.push(this.dveFactory.createTypedChannelDeclaration());
    }

    @Override
    public void exitChannelDecl(DVEParser.ChannelDeclContext ctx) {
        this.context.pop();
    }

    @Override
    public void exitType(DVEParser.TypeContext ctx) {
        Type type = null;
        if (ctx.INT() != null) {
            type = this.dveFactory.createIntegerType();
        } else if (ctx.BYTE() != null) {
            type = this.dveFactory.createByteType();
        }
        VariableDeclaration varDecl = this.node(VariableDeclaration.class);
        if (varDecl != null) {
            varDecl.setType(type);
            return;
        }
        TypedChannelDeclaration chanDecl = this.node(TypedChannelDeclaration.class);
        chanDecl.getTypes().add((Object)type);
    }

    @Override
    public void exitDeclarationIdentifier(DVEParser.DeclarationIdentifierContext ctx) {
        VariableDeclaration orig = this.node(VariableDeclaration.class);
        VariableDeclaration vdecl = (VariableDeclaration)EcoreUtil.copy((EObject)orig);
        String name = ctx.objectDecl().IDENTIFIER().getText();
        vdecl.setName(name);
        if (ctx.variableInitialization() != null) {
            vdecl.setInitial(this.exprStack.pop());
        }
        if (ctx.objectDecl().arraySelector() != null) {
            vdecl.setType(this.builder.arrayType(vdecl.getType(), this.exprStack.pop()));
        }
        this.peekContext(CompositeDeclaration.class).getDeclarations().add((Object)vdecl);
    }

    @Override
    public void exitObjectDecl(DVEParser.ObjectDeclContext ctx) {
        ChannelDeclaration orig = this.node(ChannelDeclaration.class);
        if (orig == null) {
            return;
        }
        ChannelDeclaration chan = (ChannelDeclaration)EcoreUtil.copy((EObject)orig);
        String name = ctx.IDENTIFIER().getText();
        chan.setName(name);
        TypedChannelDeclaration tchan = (TypedChannelDeclaration)(chan instanceof TypedChannelDeclaration ? chan : null);
        if (tchan != null) {
            if (ctx.arraySelector() != null) {
                tchan.setBufferSize(this.exprStack.pop());
            }
            this.peekContext(CompositeDeclaration.class).getDeclarations().add((Object)tchan);
            return;
        }
        if (ctx.arraySelector() != null) {
            this.reportError("unexpected buffered synchronization channel");
        }
        this.peekContext(CompositeDeclaration.class).getDeclarations().add((Object)chan);
    }

    @Override
    public void exitNumberLiteral(DVEParser.NumberLiteralContext ctx) {
        Literal exp = this.builder.literal(Integer.parseInt(ctx.NUMBER().getText()));
        this.exprStack.push(exp);
    }

    @Override
    public void exitBooleanLiteral(DVEParser.BooleanLiteralContext ctx) {
        switch (ctx.start.getType()) {
            case 15: {
                this.exprStack.push(this.builder.literal(true));
                break;
            }
            case 14: {
                this.exprStack.push(this.builder.literal(false));
                break;
            }
            default: {
                this.reportError("unexpected boolean literal");
            }
        }
    }

    @Override
    public void exitArrayLiteral(DVEParser.ArrayLiteralContext ctx) {
        int size = ctx.expressionList().expression().size();
        Expression[] l = new Expression[size];
        for (int i = 0; i < size; ++i) {
            l[size - i - 1] = this.exprStack.pop();
        }
        this.exprStack.push(this.builder.literal(Arrays.asList(l)));
    }

    @Override
    public void exitReference(DVEParser.ReferenceContext ctx) {
        Expression exp = null;
        if (ctx.selector() != null) {
            String processName = ctx.objectDecl(0).IDENTIFIER().getText();
            switch (ctx.selector().start.getType()) {
                case 16: {
                    ProcessVariableReference pvr = this.dveFactory.createProcessVariableReference();
                    pvr.setPrefix(this.builder.processReference(processName));
                    String variableName = ctx.objectDecl(1).IDENTIFIER().getText();
                    pvr.setRefName(variableName);
                    if (ctx.objectDecl(1).arraySelector() != null) {
                        exp = this.builder.indexedExpression(pvr, this.exprStack.pop());
                        return;
                    }
                    exp = pvr;
                    break;
                }
                case 17: {
                    ProcessStateReference psr = this.dveFactory.createProcessStateReference();
                    psr.setPrefix(this.builder.processReference(processName));
                    String stateName = ctx.objectDecl(1).IDENTIFIER().getText();
                    psr.setRefName(stateName);
                    exp = psr;
                    break;
                }
            }
            this.exprStack.push(exp);
            return;
        }
        String varName = ctx.objectDecl(0).IDENTIFIER().getText();
        VariableReference vref = this.dveFactory.createVariableReference();
        vref.setRefName(varName);
        exp = vref;
        if (ctx.objectDecl(0).arraySelector() != null) {
            exp = this.builder.indexedExpression(vref, this.exprStack.pop());
        }
        this.exprStack.push(exp);
    }

    @Override
    public void exitUnaryExpression(DVEParser.UnaryExpressionContext ctx) {
        UnaryOperator op;
        switch (ctx.operator.getType()) {
            case 37: {
                op = UnaryOperator.NOT;
                break;
            }
            case 35: {
                op = UnaryOperator.MINUS;
                break;
            }
            case 36: {
                op = UnaryOperator.BNOT;
                break;
            }
            default: {
                this.reportError("unexpected unary operator");
                return;
            }
        }
        this.exprStack.push(this.builder.unaryExpression(op, this.exprStack.pop()));
    }

    @Override
    public void exitBinaryExpression(DVEParser.BinaryExpressionContext ctx) {
        BinaryOperator op;
        switch (ctx.operator.getType()) {
            case 38: {
                op = BinaryOperator.MULT;
                break;
            }
            case 39: {
                op = BinaryOperator.DIV;
                break;
            }
            case 40: {
                op = BinaryOperator.MOD;
                break;
            }
            case 41: {
                op = BinaryOperator.PLUS;
                break;
            }
            case 35: {
                op = BinaryOperator.MINUS;
                break;
            }
            case 42: {
                op = BinaryOperator.SHL;
                break;
            }
            case 43: {
                op = BinaryOperator.SHR;
                break;
            }
            case 45: {
                op = BinaryOperator.LT;
                break;
            }
            case 44: {
                op = BinaryOperator.LEQ;
                break;
            }
            case 47: {
                op = BinaryOperator.GT;
                break;
            }
            case 46: {
                op = BinaryOperator.GEQ;
                break;
            }
            case 48: {
                op = BinaryOperator.EQ;
                break;
            }
            case 49: {
                op = BinaryOperator.NEQ;
                break;
            }
            case 50: {
                op = BinaryOperator.BOR;
                break;
            }
            case 51: {
                op = BinaryOperator.BAND;
                break;
            }
            case 52: {
                op = BinaryOperator.BXOR;
                break;
            }
            case 53: {
                op = BinaryOperator.OR;
                break;
            }
            case 54: {
                op = BinaryOperator.AND;
                break;
            }
            case 55: {
                op = BinaryOperator.IMPLY;
                break;
            }
            default: {
                this.reportError("unexpected binary operator");
                return;
            }
        }
        Expression right = this.exprStack.pop();
        Expression left = this.exprStack.pop();
        this.exprStack.push(this.builder.binaryExpression(left, op, right));
    }

    @Override
    public void exitAssignment(DVEParser.AssignmentContext ctx) {
        Transition tran = this.peekContext(Transition.class);
        Assignment assign = this.dveFactory.createAssignment();
        assign.setRhs(this.exprStack.pop());
        assign.setLhs(this.exprStack.pop());
        tran.getEffect().add((Object)assign);
    }

    @Override
    public void exitSyncExpression(DVEParser.SyncExpressionContext ctx) {
        Transition tran = this.peekContext(Transition.class);
        String channelName = ctx.IDENTIFIER().getText();
        if (ctx.syncOperator().INPUT() != null) {
            InputSynchronization isync = this.dveFactory.createInputSynchronization();
            isync.setChannel(this.builder.channelReference(channelName));
            if (ctx.expression() != null) {
                isync.setValue(this.exprStack.pop());
            }
            tran.setSync(isync);
            return;
        }
        OutputSynchronization isync = this.dveFactory.createOutputSynchronization();
        isync.setChannel(this.builder.channelReference(channelName));
        if (ctx.expression() != null) {
            isync.setValue(this.exprStack.pop());
        }
        tran.setSync(isync);
    }

    @Override
    public void exitGuard(DVEParser.GuardContext ctx) {
        Transition tran = this.peekContext(Transition.class);
        tran.setGuard(this.exprStack.pop());
    }

    @Override
    public void enterTransition(DVEParser.TransitionContext ctx) {
        this.pushContext(this.dveFactory.createTransition());
    }

    @Override
    public void exitTransition(DVEParser.TransitionContext ctx) {
        Transition tran = this.popContext(Transition.class);
        if (ctx.IDENTIFIER(0) != null) {
            tran.setFrom(this.builder.stateReference(ctx.IDENTIFIER(0).getText()));
        }
        tran.setTo(this.builder.stateReference(ctx.IDENTIFIER(1).getText()));
        Process proc = this.peekContext(Process.class);
        proc.getTransitions().add((Object)tran);
    }

    @Override
    public void exitAcceptDecl(DVEParser.AcceptDeclContext ctx) {
        EList<StateReference> stateList = this.peekContext(Process.class).getAccepting();
        for (TerminalNode id : ctx.identifierList().IDENTIFIER()) {
            StateReference ref = this.dveFactory.createStateReference();
            ref.setRefName(id.getText());
            stateList.add(ref);
        }
    }

    @Override
    public void exitCommitDecl(DVEParser.CommitDeclContext ctx) {
        EList<StateReference> stateList = this.peekContext(Process.class).getCommited();
        for (TerminalNode id : ctx.identifierList().IDENTIFIER()) {
            StateReference ref = this.dveFactory.createStateReference();
            ref.setRefName(id.getText());
            stateList.add(ref);
        }
    }

    @Override
    public void exitInitDecl(DVEParser.InitDeclContext ctx) {
        StateReference sr = this.dveFactory.createStateReference();
        sr.setRefName(ctx.IDENTIFIER().getText());
        this.peekContext(Process.class).setInitial(sr);
    }

    @Override
    public void exitStates(DVEParser.StatesContext ctx) {
        EList<State> stateList = this.peekContext(Process.class).getStates();
        for (TerminalNode id : ctx.identifierList().IDENTIFIER()) {
            State state = this.builder.state(id.getText());
            stateList.add(state);
        }
    }

    @Override
    public void enterProcessDecl(DVEParser.ProcessDeclContext ctx) {
        this.pushContext(this.dveFactory.createProcess());
    }

    @Override
    public void exitProcessDecl(DVEParser.ProcessDeclContext ctx) {
        Process proc = this.popContext(Process.class);
        proc.setName(ctx.IDENTIFIER().getText());
        System sys = this.peekContext(System.class);
        sys.getDeclarations().add((Object)proc);
        sys.getProcesses().add((Object)proc);
    }

    @Override
    public void exitProperty(DVEParser.PropertyContext ctx) {
        ProcessReference pr = this.builder.processReference(ctx.IDENTIFIER().getText());
        this.peekContext(SystemProperties.class).setProperty(pr);
    }

    @Override
    public void exitSystemType(DVEParser.SystemTypeContext ctx) {
        SystemType st = null;
        if (ctx.ASYNC() != null) {
            st = this.dveFactory.createAsynchronous();
        } else if (ctx.SYNC() != null) {
            st = this.dveFactory.createSynchronous();
        }
        this.peekContext(SystemProperties.class).setSystemType(st);
    }

    @Override
    public void enterSystemProperties(DVEParser.SystemPropertiesContext ctx) {
        this.pushContext(this.dveFactory.createSystemProperties());
    }

    @Override
    public void exitSystemProperties(DVEParser.SystemPropertiesContext ctx) {
        SystemProperties props = this.popContext(SystemProperties.class);
        this.peekContext(System.class).setProperties(props);
    }

    @Override
    public void enterSystem(DVEParser.SystemContext ctx) {
        this.pushContext(this.dveFactory.createSystem());
    }

    @Override
    public void exitSystem(DVEParser.SystemContext ctx) {
        this.system = this.popContext(System.class);
    }
}

