/*
 * Decompiled with CFR 0.152.
 */
package plug.core.execution;

import announce4j.Announcer;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import plug.core.ILanguagePlugin;
import plug.core.IRuntimeView;
import plug.core.IStateSpaceManager;
import plug.core.ITransitionRelation;
import plug.core.execution.ControllerProviderFunction;
import plug.core.execution.IExecutionController;
import plug.events.ExecutionEndedEvent;
import plug.events.PropertyEvent;
import plug.simulation.trace_storage.TraceStore;
import plug.statespace.SimpleStateSpaceManager;
import plug.utils.graph.algorithms.DijkstraShortestPath;
import plug.verifiers.deadlock.FinalStateDetected;

public class Execution {
    public Status status = Status.CREATED;
    protected final String name;
    ILanguagePlugin languagePlugin;
    Path modelPath;
    ControllerProviderFunction description;
    ITransitionRelation transitionRelation;
    IRuntimeView runtimeView;
    IExecutionController controller;
    public TraceStore traceStore = new TraceStore();
    protected Thread thread;
    Throwable exception;
    PropertyEvent violation;
    protected long loadingTime = 0L;
    protected long startTime = 0L;
    protected long endTime = 0L;

    public Execution(String name, Path modelPath, ILanguagePlugin languagePlugin, ControllerProviderFunction description) {
        this.name = name;
        this.modelPath = modelPath;
        this.languagePlugin = languagePlugin;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public Status status() {
        return this.status;
    }

    public PropertyEvent getViolation() {
        return this.violation;
    }

    public Throwable getException() {
        return this.exception;
    }

    public ITransitionRelation getTransitionRelation() {
        if (this.status != Status.INITIALIZED) {
            this.initialize();
        }
        return this.transitionRelation;
    }

    public IRuntimeView getRuntimeView() {
        if (this.status != Status.INITIALIZED) {
            this.initialize();
        }
        return this.runtimeView;
    }

    public synchronized void initialize() {
        if (this.status != Status.CREATED && this.status != Status.FAILED) {
            return;
        }
        try {
            long startLoading = System.currentTimeMillis();
            this.transitionRelation = this.languagePlugin.getLoader().getRuntime(this.modelPath.toAbsolutePath().toString(), null);
            this.runtimeView = this.languagePlugin.getRuntimeView(this.transitionRelation);
            SimpleStateSpaceManager stateSpaceManager = new SimpleStateSpaceManager();
            stateSpaceManager.parentTransitionStorage();
            this.controller = this.description.createController(this.transitionRelation, stateSpaceManager);
            this.loadingTime = System.currentTimeMillis() - startLoading;
        }
        catch (Throwable e) {
            this.exception = e;
            this.status = Status.FAILED;
            return;
        }
        this.status = this.transitionRelation == null || this.controller == null ? Status.FAILED : Status.INITIALIZED;
    }

    public synchronized Thread run() {
        if (this.status != Status.INITIALIZED) {
            return null;
        }
        try {
            this.thread = new Thread(this::runnerThread);
            this.status = Status.RUNNING;
            this.thread.start();
        }
        catch (Throwable e) {
            this.exception = e;
            this.status = Status.FAILED;
            return null;
        }
        return this.thread;
    }

    public synchronized void pause() {
        if (this.status != Status.RUNNING) {
            return;
        }
        this.controller.getMonitor().pause();
        this.status = Status.PAUSED;
    }

    public synchronized void resume() {
        if (this.status != Status.PAUSED) {
            return;
        }
        this.controller.getMonitor().resume();
        this.status = Status.RUNNING;
    }

    public synchronized void stop() {
        if (this.status != Status.PAUSED && this.status != Status.RUNNING) {
            return;
        }
        this.controller.getMonitor().hasToFinish();
        this.status = Status.STOPPED;
    }

    public synchronized void reset() {
        if (this.status != Status.STOPPED && this.status != Status.FAILED && this.status != Status.FINISHED) {
            return;
        }
        this.controller = null;
        this.traceStore = new TraceStore();
        this.endTime = 0L;
        this.startTime = 0L;
        this.exception = null;
        this.violation = null;
        this.thread = null;
        this.status = Status.CREATED;
    }

    public synchronized void hardReset() {
        try {
            this.controller.getMonitor().hasToFinish();
            this.controller = null;
            this.traceStore = new TraceStore();
            this.endTime = 0L;
            this.startTime = 0L;
            this.exception = null;
            this.violation = null;
            this.thread = null;
        }
        catch (Throwable e) {
            this.exception = e;
            this.status = Status.FAILED;
            return;
        }
        this.status = Status.CREATED;
    }

    void runnerThread() {
        Announcer announcer = this.controller.getAnnouncer();
        announcer.when(ExecutionEndedEvent.class, (a, event) -> {
            this.endTime = System.currentTimeMillis();
            this.status = Status.FINISHED;
        });
        announcer.when(PropertyEvent.class, (a, event) -> {
            if (!event.isVerified()) {
                this.controller.getMonitor().hasToFinish();
                this.violation = event;
                this.endTime = System.currentTimeMillis();
                this.status = Status.FINISHED;
                this.traceStore.addSteps(Collections.emptyList(), event.getCounterExample(), this.transitionRelation::actionFromSourceToTarget);
                this.traceStore.hasCounterExample = true;
            }
        });
        announcer.when(FinalStateDetected.class, (a, event) -> {
            this.controller.getMonitor().hasToFinish();
            IStateSpaceManager stateSpaceManager = this.controller.getStateSpaceManager();
            List counterExample = new DijkstraShortestPath().getShortestPath(stateSpaceManager.getGraphView(), stateSpaceManager.initialConfigurations(), event.getFinalState());
            PropertyEvent deadlock = new PropertyEvent(this.controller, false, "deadlock", counterExample);
            this.controller.getAnnouncer().announce(deadlock);
        });
        try {
            this.startTime = System.currentTimeMillis();
            this.controller.execute();
        }
        catch (Throwable e) {
            this.exception = e;
            this.status = Status.FAILED;
            return;
        }
    }

    public long getElapsedTime() {
        if (this.startTime == 0L) {
            return 0L;
        }
        if (this.endTime == 0L) {
            return System.currentTimeMillis() - this.startTime;
        }
        return this.endTime - this.startTime;
    }

    public long getLoadingTime() {
        return this.loadingTime;
    }

    public int configurationCount() {
        if (this.controller == null) {
            return 0;
        }
        return this.controller.getStateSpaceManager().size();
    }

    public int transitionCount() {
        if (this.controller == null) {
            return 0;
        }
        return this.controller.getStateSpaceManager().transitionCount();
    }

    public String getDetails() {
        int size;
        if (this.status == Status.CREATED) {
            return "initializing";
        }
        if (this.status == Status.INITIALIZED) {
            return "no results";
        }
        StringBuilder result = new StringBuilder();
        if (this.status == Status.FAILED || this.status == Status.STOPPED) {
            result.append("Incomplete ");
        }
        if (this.status == Status.FINISHED) {
            result.append("Finished ");
        }
        if ((size = this.configurationCount()) > 0) {
            result.append(size + " configurations ");
            int transitionCount = this.transitionCount();
            if (transitionCount > 0) {
                result.append(transitionCount + " transitions ");
            }
            result.append("in " + this.getElapsedTime() + " ms");
        }
        return result.toString();
    }

    public VerificationStatus verificationStatus() {
        if (this.status != Status.FINISHED) {
            return VerificationStatus.UNKNOWN;
        }
        if (this.violation == null) {
            return VerificationStatus.SATISFIED;
        }
        return VerificationStatus.VIOLATED;
    }

    public CompletenessStatus resultStatus() {
        if (this.status == Status.FINISHED) {
            return CompletenessStatus.COMPLETE;
        }
        return CompletenessStatus.INCOMPLETE;
    }

    public static enum CompletenessStatus {
        COMPLETE,
        INCOMPLETE;

    }

    public static enum VerificationStatus {
        SATISFIED,
        VIOLATED,
        UNKNOWN;

    }

    public static enum Status {
        CREATED,
        INITIALIZED,
        RUNNING,
        PAUSED,
        STOPPED,
        FINISHED,
        FAILED;

    }
}

