/*
 * Decompiled with CFR 0.152.
 */
package org.petitparser.grammar.xml.ast;

import java.util.Objects;
import org.petitparser.grammar.xml.ast.XmlName;
import org.petitparser.grammar.xml.ast.XmlNode;

public class XmlAttribute
extends XmlNode {
    private final XmlName name;
    private final String value;

    public XmlAttribute(XmlName name, String value) {
        this.name = name;
        this.value = value;
    }

    public XmlName getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public void writeTo(StringBuffer buffer) {
        this.name.writeTo(buffer);
        buffer.append("=\"").append(this.value).append("\"");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        XmlAttribute other = (XmlAttribute)obj;
        return this.name.equals(other.name) && this.value.equals(other.value);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }
}

