/*
 * Decompiled with CFR 0.152.
 */
package plug.language.tuml.simulation.ui;

import java.util.ArrayList;
import java.util.Map;
import java.util.Queue;
import org.eclipse.uml2.uml.Signal;
import plug.core.view.ConfigurationItem;
import tuml.interpreter.ActiveObject;
import tuml.interpreter.Composite;
import tuml.interpreter.IAbstractVisitor;

public class ConfigurationItemGenerator
implements IAbstractVisitor<ConfigurationItem> {
    static final String processIcon = "/plug/language/tuml/icones/thread_obj.gif";
    static final String stateIcon = "/plug/language/tuml/icones/icon_state.gif";
    static final String peersIcon = "/plug/language/tuml/icones/icon_assoc.png";
    static final String eventpoolIcon = "/plug/language/tuml/icones/queue.png";
    static final String actorIcon = "/plug/language/tuml/icones/actor.png";
    static final String localVarIcon = "/plug/language/tuml/icones/member_local.png";
    static final String variablesIcon = "/plug/language/tuml/icones/variables.png";

    public ConfigurationItem visitActiveObject(ActiveObject node) {
        ArrayList<ConfigurationItem> children = new ArrayList<ConfigurationItem>();
        children.add(new ConfigurationItem("state", node.getCurrentState().getName(), stateIcon, null));
        children.add(new ConfigurationItem("queue", this.toStringEventPool(node.getEventPool()), eventpoolIcon, null));
        if (!node.getPeers().isEmpty()) {
            ArrayList<ConfigurationItem> peersChildren = new ArrayList<ConfigurationItem>();
            for (String name : node.getPeers().keySet()) {
                peersChildren.add(new ConfigurationItem("peer", name, actorIcon, null));
            }
            ConfigurationItem peers = new ConfigurationItem("peers", "peers", peersIcon, peersChildren);
            children.add(peers);
            peers.setExpanded(true);
        }
        if (!node.getLocalVars().isEmpty()) {
            ArrayList<ConfigurationItem> variablesChildren = new ArrayList<ConfigurationItem>();
            for (Map.Entry local : node.getLocalVars().entrySet()) {
                variablesChildren.add(new ConfigurationItem("variable", local.toString(), localVarIcon, null));
            }
            ConfigurationItem variables = new ConfigurationItem("variables", "locals", variablesIcon, variablesChildren);
            children.add(variables);
            variables.setExpanded(true);
        }
        ConfigurationItem root = new ConfigurationItem("process", node.toShortString().toString(), processIcon, children);
        root.setExpanded(true);
        return root;
    }

    public ConfigurationItem visitComposite(Composite node) {
        ArrayList<Object> children = new ArrayList<Object>();
        for (ActiveObject aO : node.getParts()) {
            children.add(aO.accept((IAbstractVisitor)this));
        }
        ConfigurationItem root = new ConfigurationItem("variable", node.getC().getName(), variablesIcon, children);
        root.setExpanded(true);
        return root;
    }

    String toStringEventPool(Queue<Signal> ep) {
        Queue<Signal> q = ep;
        String s = "[";
        boolean first = true;
        for (Signal sig : q) {
            if (!first) {
                s = s + ", ";
            } else {
                first = false;
            }
            s = s + sig.getName();
        }
        s = s + "]";
        return s;
    }
}

