/*
 * Decompiled with CFR 0.152.
 */
package tuml.interpreter.parsercombinator;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.MapExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;
import tuml.interpreter.parsercombinator.ParserCombinator;

public class GrammarLanguage
extends ParserCombinator {
    private static ParserCombinator.Parser<Grammar> parser;

    public static ParserCombinator.Parser<Grammar> getParser() {
        ParserCombinator.Parser<Grammar> _xblockexpression = null;
        boolean _equals = Objects.equal(parser, null);
        if (_equals) {
            ParserCombinator.Parser<Object> ident = ParserCombinator.terminal("([A-Za-z_]\\w*)");
            ParserCombinator.Parser<Object> _terminal = ParserCombinator.terminal("\"([^\"]*)\"");
            ParserCombinator.CreatingParser<Symbol> term = _terminal.create(Symbol.class, new Object[0]);
            ParserCombinator.Parser<Object> _terminal_1 = ParserCombinator.terminal("/((?:[^/\\\\]|\\\\.)*)/");
            ParserCombinator.CreatingParser<Terminal> regex = _terminal_1.create(Terminal.class, new Object[0]);
            ParserCombinator.WrappingParser<Object> exp = new ParserCombinator.WrappingParser<Object>();
            ParserCombinator.CreatingParser<RuleCall> _create = ident.create(RuleCall.class, new Object[0]);
            ParserCombinator.Parser<RuleCall> _or = term.or(_create);
            ParserCombinator.Parser<Terminal> _or_1 = _or.or(regex);
            ParserCombinator.Parser<Object> _isymb = ParserCombinator.isymb("(");
            ParserCombinator.Parser<Object> _then = _isymb.then(exp);
            ParserCombinator.Parser<Object> _isymb_1 = ParserCombinator.isymb(")");
            ParserCombinator.Parser<Object> _then_1 = _then.then(_isymb_1);
            ParserCombinator.Parser<Object> primitiveExp = _or_1.or(_then_1);
            ParserCombinator.Parser<Object> _symb = ParserCombinator.symb("*");
            ParserCombinator.Parser<Object> _symb_1 = ParserCombinator.symb("+");
            ParserCombinator.Parser<Object> _symb_2 = ParserCombinator.symb("?");
            ParserCombinator.Parser<Object> _or_2 = _symb_1.or(_symb_2);
            ParserCombinator.Parser<Object> _or_3 = _symb.or(_or_2);
            ParserCombinator.Parser<Object> _symb_3 = ParserCombinator.symb("#");
            ParserCombinator.Parser<Object> _multSet = _symb_3.multSet(0, 1);
            ParserCombinator.Parser<Object> _then_2 = _or_3.then(_multSet);
            ParserCombinator.Parser<Object> _isymb_2 = ParserCombinator.isymb(",");
            ParserCombinator.Parser<Object> _then_3 = _isymb_2.then(primitiveExp);
            ParserCombinator.Parser<Object> _multSet_1 = _then_3.multSet(0, 1);
            ParserCombinator.Parser<Object> _then_4 = _then_2.then(_multSet_1);
            ParserCombinator.Parser<Object> _then_5 = primitiveExp.then(_then_4);
            ParserCombinator.CreatingParser<Repetition> _create_1 = _then_5.create(Repetition.class, new Object[0]);
            ParserCombinator.Parser<Object> _isymb_3 = ParserCombinator.isymb("!");
            ParserCombinator.Parser<Object> _then_6 = primitiveExp.then(_isymb_3);
            ParserCombinator.CreatingParser<Drop> _create_2 = _then_6.create(Drop.class, new Object[0]);
            ParserCombinator.Parser<Drop> _or_4 = _create_1.or(_create_2);
            ParserCombinator.Parser<Object> priority0 = _or_4.or(primitiveExp);
            ParserCombinator.CreatingParser<Sequence> _create_3 = priority0.create(Sequence.class, new Object[0]);
            ParserCombinator.Parser _mult = _create_3.mult(0, -1);
            ParserCombinator.Parser<Object> priority1 = priority0.then(_mult);
            ParserCombinator.Parser<Object> _isymb_4 = ParserCombinator.isymb("{");
            ParserCombinator.Parser<Object> _then_7 = _isymb_4.then(ident);
            ParserCombinator.Parser<Object> _isymb_5 = ParserCombinator.isymb("(");
            ParserCombinator.Parser<Object> _then_8 = _then_7.then(_isymb_5);
            ParserCombinator.Parser<Object> _isymb_6 = ParserCombinator.isymb(",");
            ParserCombinator.Parser<Object> _multSet_2 = ident.multSet(0, -1, _isymb_6);
            ParserCombinator.Parser<Object> _then_9 = _then_8.then(_multSet_2);
            ParserCombinator.Parser<Object> _isymb_7 = ParserCombinator.isymb(")");
            ParserCombinator.Parser<Object> _then_10 = _then_9.then(_isymb_7);
            ParserCombinator.Parser<Object> _isymb_8 = ParserCombinator.isymb("}");
            ParserCombinator.Parser<Object> _then_11 = _then_10.then(_isymb_8);
            ParserCombinator.CreatingParser<Creation> _create_4 = _then_11.create(Creation.class, new Object[0]);
            ParserCombinator.Parser<Creation> _then_12 = priority1.then(_create_4);
            ParserCombinator.Parser<Object> priority2 = _then_12.or(priority1);
            ParserCombinator.Parser<Object> _isymb_9 = ParserCombinator.isymb("|");
            ParserCombinator.Parser<Object> _then_13 = _isymb_9.then(priority2);
            ParserCombinator.CreatingParser<Alternative> _create_5 = _then_13.create(Alternative.class, new Object[0]);
            ParserCombinator.Parser _mult_1 = _create_5.mult(0, -1);
            ParserCombinator.Parser<Object> priority3 = priority2.then(_mult_1);
            exp.set(priority3);
            ParserCombinator.Parser<Object> _isymb_10 = ParserCombinator.isymb(":=");
            ParserCombinator.Parser<Object> _then_14 = ident.then(_isymb_10);
            ParserCombinator.Parser<Object> _then_15 = _then_14.then(exp);
            ParserCombinator.Parser<Object> _isymb_11 = ParserCombinator.isymb(";");
            ParserCombinator.Parser<Object> _then_16 = _then_15.then(_isymb_11);
            ParserCombinator.CreatingParser<ProductionRule> productionRule = _then_16.create(ProductionRule.class, new Object[0]);
            ParserCombinator.Parser<Grammar> _multSet_3 = productionRule.multSet(1, -1);
            ParserCombinator.CreatingParser<Grammar> _create_6 = _multSet_3.create(Grammar.class, new Object[0]);
            parser = _create_6;
        }
        _xblockexpression = parser;
        return _xblockexpression;
    }

    @Data
    public static class Creation
    extends Expression {
        private final Expression expression;
        private final String nodeType;
        private final Set<String> argumentNames;

        @Override
        public ParserCombinator.Parser<Object> eval(Map<String, ? extends ParserCombinator.Parser<Object>> rules) {
            ParserCombinator.Parser<Object> _eval = this.expression.eval(rules);
            return new ParserCombinator.NodeCreatingParser<Object>(_eval, this.nodeType, (String[])Conversions.unwrapArray(this.argumentNames, String.class));
        }

        public Creation(Expression expression, String nodeType, Set<String> argumentNames) {
            this.expression = expression;
            this.nodeType = nodeType;
            this.argumentNames = argumentNames;
        }

        @Override
        @Pure
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.expression == null ? 0 : this.expression.hashCode());
            result = 31 * result + (this.nodeType == null ? 0 : this.nodeType.hashCode());
            result = 31 * result + (this.argumentNames == null ? 0 : this.argumentNames.hashCode());
            return result;
        }

        @Override
        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            if (!super.equals(obj)) {
                return false;
            }
            Creation other = (Creation)obj;
            if (this.expression == null ? other.expression != null : !this.expression.equals(other.expression)) {
                return false;
            }
            if (this.nodeType == null ? other.nodeType != null : !this.nodeType.equals(other.nodeType)) {
                return false;
            }
            return !(this.argumentNames == null ? other.argumentNames != null : !this.argumentNames.equals(other.argumentNames));
        }

        @Override
        @Pure
        public String toString() {
            String result = new ToStringBuilder((Object)this).addAllFields().toString();
            return result;
        }

        @Pure
        public Expression getExpression() {
            return this.expression;
        }

        @Pure
        public String getNodeType() {
            return this.nodeType;
        }

        @Pure
        public Set<String> getArgumentNames() {
            return this.argumentNames;
        }
    }

    @Data
    public static class Drop
    extends Expression {
        private final Expression expression;

        @Override
        public ParserCombinator.Parser<Object> eval(Map<String, ? extends ParserCombinator.Parser<Object>> rules) {
            ParserCombinator.Parser<Object> _eval = this.expression.eval(rules);
            return new ParserCombinator.DroppingParser<Object>(_eval);
        }

        public Drop(Expression expression) {
            this.expression = expression;
        }

        @Override
        @Pure
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.expression == null ? 0 : this.expression.hashCode());
            return result;
        }

        @Override
        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            if (!super.equals(obj)) {
                return false;
            }
            Drop other = (Drop)obj;
            return !(this.expression == null ? other.expression != null : !this.expression.equals(other.expression));
        }

        @Override
        @Pure
        public String toString() {
            String result = new ToStringBuilder((Object)this).addAllFields().toString();
            return result;
        }

        @Pure
        public Expression getExpression() {
            return this.expression;
        }
    }

    @Data
    public static class Repetition
    extends Expression {
        private final Expression expression;
        private final String op;
        private final Collection<String> asSet;
        private final Collection<Expression> separator;

        @Override
        public ParserCombinator.Parser<Object> eval(Map<String, ? extends ParserCombinator.Parser<Object>> rules) {
            ParserCombinator.MultParser<Object> _xblockexpression = null;
            Pair _switchResult = null;
            String op = this.op;
            boolean _matched = false;
            if (!_matched && Objects.equal((Object)op, (Object)"?")) {
                _matched = true;
                _switchResult = Pair.of((Object)0, (Object)1);
            }
            if (!_matched && Objects.equal((Object)op, (Object)"*")) {
                _matched = true;
                _switchResult = Pair.of((Object)0, (Object)-1);
            }
            if (!_matched && Objects.equal((Object)op, (Object)"+")) {
                _matched = true;
                _switchResult = Pair.of((Object)1, (Object)-1);
            }
            if (!_matched) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append((Object)"error: unsupported repetition operator: ");
                _builder.append((Object)this.op, "");
                throw new RuntimeException(_builder.toString());
            }
            Pair mult = _switchResult;
            ParserCombinator.Parser<Object> _xifexpression = null;
            boolean _isEmpty = this.separator.isEmpty();
            if (_isEmpty) {
                _xifexpression = null;
            } else {
                Functions.Function1<Expression, Boolean> _function = new Functions.Function1<Expression, Boolean>(){

                    public Boolean apply(Expression it) {
                        return true;
                    }
                };
                Expression _findFirst = (Expression)IterableExtensions.findFirst(this.separator, (Functions.Function1)_function);
                _xifexpression = _findFirst.eval(rules);
            }
            ParserCombinator.Parser<Object> sep = _xifexpression;
            ParserCombinator.Parser<Object> _eval = this.expression.eval(rules);
            Integer _key = (Integer)mult.getKey();
            Integer _value = (Integer)mult.getValue();
            boolean _isEmpty_1 = this.asSet.isEmpty();
            boolean _not = !_isEmpty_1;
            _xblockexpression = new ParserCombinator.MultParser<Object>(_eval, _key, _value, _not, sep);
            return _xblockexpression;
        }

        public Repetition(Expression expression, String op, Collection<String> asSet, Collection<Expression> separator) {
            this.expression = expression;
            this.op = op;
            this.asSet = asSet;
            this.separator = separator;
        }

        @Override
        @Pure
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.expression == null ? 0 : this.expression.hashCode());
            result = 31 * result + (this.op == null ? 0 : this.op.hashCode());
            result = 31 * result + (this.asSet == null ? 0 : this.asSet.hashCode());
            result = 31 * result + (this.separator == null ? 0 : this.separator.hashCode());
            return result;
        }

        @Override
        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            if (!super.equals(obj)) {
                return false;
            }
            Repetition other = (Repetition)obj;
            if (this.expression == null ? other.expression != null : !this.expression.equals(other.expression)) {
                return false;
            }
            if (this.op == null ? other.op != null : !this.op.equals(other.op)) {
                return false;
            }
            if (this.asSet == null ? other.asSet != null : !this.asSet.equals(other.asSet)) {
                return false;
            }
            return !(this.separator == null ? other.separator != null : !this.separator.equals(other.separator));
        }

        @Override
        @Pure
        public String toString() {
            String result = new ToStringBuilder((Object)this).addAllFields().toString();
            return result;
        }

        @Pure
        public Expression getExpression() {
            return this.expression;
        }

        @Pure
        public String getOp() {
            return this.op;
        }

        @Pure
        public Collection<String> getAsSet() {
            return this.asSet;
        }

        @Pure
        public Collection<Expression> getSeparator() {
            return this.separator;
        }
    }

    @Data
    public static class Sequence
    extends Expression {
        private final Expression left;
        private final Expression right;

        @Override
        public ParserCombinator.Parser<Object> eval(Map<String, ? extends ParserCombinator.Parser<Object>> rules) {
            ParserCombinator.Parser<Object> _eval = this.left.eval(rules);
            ParserCombinator.Parser<Object> _eval_1 = this.right.eval(rules);
            return new ParserCombinator.ThenParser<Object>(_eval, _eval_1);
        }

        public Sequence(Expression left, Expression right) {
            this.left = left;
            this.right = right;
        }

        @Override
        @Pure
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.left == null ? 0 : this.left.hashCode());
            result = 31 * result + (this.right == null ? 0 : this.right.hashCode());
            return result;
        }

        @Override
        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            if (!super.equals(obj)) {
                return false;
            }
            Sequence other = (Sequence)obj;
            if (this.left == null ? other.left != null : !this.left.equals(other.left)) {
                return false;
            }
            return !(this.right == null ? other.right != null : !this.right.equals(other.right));
        }

        @Override
        @Pure
        public String toString() {
            String result = new ToStringBuilder((Object)this).addAllFields().toString();
            return result;
        }

        @Pure
        public Expression getLeft() {
            return this.left;
        }

        @Pure
        public Expression getRight() {
            return this.right;
        }
    }

    @Data
    public static class Alternative
    extends Expression {
        private final Expression left;
        private final Expression right;

        @Override
        public ParserCombinator.Parser<Object> eval(Map<String, ? extends ParserCombinator.Parser<Object>> rules) {
            ParserCombinator.Parser<Object> _eval = this.left.eval(rules);
            ParserCombinator.Parser<Object> _eval_1 = this.right.eval(rules);
            return new ParserCombinator.OrParser<Object>(_eval, _eval_1);
        }

        public Alternative(Expression left, Expression right) {
            this.left = left;
            this.right = right;
        }

        @Override
        @Pure
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.left == null ? 0 : this.left.hashCode());
            result = 31 * result + (this.right == null ? 0 : this.right.hashCode());
            return result;
        }

        @Override
        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            if (!super.equals(obj)) {
                return false;
            }
            Alternative other = (Alternative)obj;
            if (this.left == null ? other.left != null : !this.left.equals(other.left)) {
                return false;
            }
            return !(this.right == null ? other.right != null : !this.right.equals(other.right));
        }

        @Override
        @Pure
        public String toString() {
            String result = new ToStringBuilder((Object)this).addAllFields().toString();
            return result;
        }

        @Pure
        public Expression getLeft() {
            return this.left;
        }

        @Pure
        public Expression getRight() {
            return this.right;
        }
    }

    @Data
    public static class RuleCall
    extends Expression {
        private final String ruleName;

        @Override
        public ParserCombinator.Parser<Object> eval(Map<String, ? extends ParserCombinator.Parser<Object>> rules) {
            ParserCombinator.Parser<Object> _xblockexpression = null;
            ParserCombinator.Parser<Object> ret = rules.get(this.ruleName);
            boolean _equals = Objects.equal(ret, null);
            if (_equals) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append((Object)"error: rule ");
                _builder.append((Object)this.ruleName, "");
                _builder.append((Object)" not found");
                throw new RuntimeException(_builder.toString());
            }
            _xblockexpression = ret;
            return _xblockexpression;
        }

        public RuleCall(String ruleName) {
            this.ruleName = ruleName;
        }

        @Override
        @Pure
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.ruleName == null ? 0 : this.ruleName.hashCode());
            return result;
        }

        @Override
        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            if (!super.equals(obj)) {
                return false;
            }
            RuleCall other = (RuleCall)obj;
            return !(this.ruleName == null ? other.ruleName != null : !this.ruleName.equals(other.ruleName));
        }

        @Override
        @Pure
        public String toString() {
            String result = new ToStringBuilder((Object)this).addAllFields().toString();
            return result;
        }

        @Pure
        public String getRuleName() {
            return this.ruleName;
        }
    }

    @Data
    public static class Terminal
    extends Expression {
        private final String value;

        @Override
        public ParserCombinator.Parser<Object> eval(Map<String, ? extends ParserCombinator.Parser<Object>> rules) {
            return new ParserCombinator.TerminalParser<Object>(this.value);
        }

        public Terminal(String value) {
            this.value = value;
        }

        @Override
        @Pure
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        @Override
        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            if (!super.equals(obj)) {
                return false;
            }
            Terminal other = (Terminal)obj;
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        @Override
        @Pure
        public String toString() {
            String result = new ToStringBuilder((Object)this).addAllFields().toString();
            return result;
        }

        @Pure
        public String getValue() {
            return this.value;
        }
    }

    @Data
    public static class Symbol
    extends Expression {
        private final String value;

        @Override
        public ParserCombinator.Parser<Object> eval(Map<String, ? extends ParserCombinator.Parser<Object>> rules) {
            return new ParserCombinator.SymbolParser<Object>(this.value, false);
        }

        public Symbol(String value) {
            this.value = value;
        }

        @Override
        @Pure
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        @Override
        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            if (!super.equals(obj)) {
                return false;
            }
            Symbol other = (Symbol)obj;
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        @Override
        @Pure
        public String toString() {
            String result = new ToStringBuilder((Object)this).addAllFields().toString();
            return result;
        }

        @Pure
        public String getValue() {
            return this.value;
        }
    }

    @Data
    public static abstract class Expression
    extends GrammarNode {
        public abstract ParserCombinator.Parser<Object> eval(Map<String, ? extends ParserCombinator.Parser<Object>> var1);

        @Override
        @Pure
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            return result;
        }

        @Override
        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            if (!super.equals(obj)) {
                return false;
            }
            Expression other = (Expression)obj;
            return true;
        }

        @Override
        @Pure
        public String toString() {
            String result = new ToStringBuilder((Object)this).addAllFields().toString();
            return result;
        }
    }

    @Data
    public static class ProductionRule
    extends GrammarNode {
        private final String name;
        private final Expression body;

        public ProductionRule(String name, Expression body) {
            this.name = name;
            this.body = body;
        }

        @Override
        @Pure
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.body == null ? 0 : this.body.hashCode());
            return result;
        }

        @Override
        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            if (!super.equals(obj)) {
                return false;
            }
            ProductionRule other = (ProductionRule)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.body == null ? other.body != null : !this.body.equals(other.body));
        }

        @Override
        @Pure
        public String toString() {
            String result = new ToStringBuilder((Object)this).addAllFields().toString();
            return result;
        }

        @Pure
        public String getName() {
            return this.name;
        }

        @Pure
        public Expression getBody() {
            return this.body;
        }
    }

    @Data
    public static class Grammar
    extends GrammarNode {
        private final Set<ProductionRule> productionRules;

        public ParserCombinator.WrappingParser<Object> eval() {
            ParserCombinator.WrappingParser _xblockexpression = null;
            Functions.Function1<ProductionRule, String> _function = new Functions.Function1<ProductionRule, String>(){

                public String apply(ProductionRule it) {
                    return it.name;
                }
            };
            Map _map = IterableExtensions.toMap(this.productionRules, (Functions.Function1)_function);
            Functions.Function1<ProductionRule, ParserCombinator.WrappingParser<Object>> _function_1 = new Functions.Function1<ProductionRule, ParserCombinator.WrappingParser<Object>>(){

                public ParserCombinator.WrappingParser<Object> apply(ProductionRule it) {
                    return new ParserCombinator.WrappingParser<Object>();
                }
            };
            Map _mapValues = MapExtensions.mapValues((Map)_map, (Functions.Function1)_function_1);
            ImmutableMap rules = ImmutableMap.copyOf((Map)_mapValues);
            Consumer<ProductionRule> _function_2 = new Consumer<ProductionRule>((Map)rules){
                final /* synthetic */ Map val$rules;
                {
                    this.val$rules = map;
                }

                @Override
                public void accept(ProductionRule productionRule) {
                    ParserCombinator.WrappingParser _get = (ParserCombinator.WrappingParser)this.val$rules.get(productionRule.name);
                    ParserCombinator.Parser<Object> _eval = productionRule.body.eval(this.val$rules);
                    _get.set(_eval);
                }
            };
            this.productionRules.forEach(_function_2);
            ProductionRule _get = ((ProductionRule[])Conversions.unwrapArray(this.productionRules, ProductionRule.class))[0];
            _xblockexpression = (ParserCombinator.WrappingParser)rules.get(_get.name);
            return _xblockexpression;
        }

        public Grammar(Set<ProductionRule> productionRules) {
            this.productionRules = productionRules;
        }

        @Override
        @Pure
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.productionRules == null ? 0 : this.productionRules.hashCode());
            return result;
        }

        @Override
        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            if (!super.equals(obj)) {
                return false;
            }
            Grammar other = (Grammar)obj;
            return !(this.productionRules == null ? other.productionRules != null : !this.productionRules.equals(other.productionRules));
        }

        @Override
        @Pure
        public String toString() {
            String result = new ToStringBuilder((Object)this).addAllFields().toString();
            return result;
        }

        @Pure
        public Set<ProductionRule> getProductionRules() {
            return this.productionRules;
        }
    }

    @Data
    public static abstract class GrammarNode {
        @Pure
        public int hashCode() {
            int prime = 31;
            int result = 1;
            return result;
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GrammarNode other = (GrammarNode)obj;
            return true;
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            return b.toString();
        }
    }
}

