/*
 * Decompiled with CFR 0.152.
 */
package org.xid.basics.geometry;

import org.xid.basics.geometry.Geometry;

public class Polyline {
    public static final float absoluteError = 0.01f;

    public static int numPoints(float[] points) {
        return points.length / 2;
    }

    public static float[] getPoint(float[] points, int index) {
        int i = index * 2;
        return new float[]{points[i], points[i + 1]};
    }

    public static float[] getSegmentMiddlePoint(float[] points, int index) {
        int i = index * 2;
        return new float[]{(points[i] + points[i + 2]) / 2.0f, (points[i + 1] + points[i + 3]) / 2.0f};
    }

    public static float segmentLengthSquared(float[] polyline, int segmentIndex) {
        int i = segmentIndex * 2;
        float dx = polyline[i + 2] - polyline[i];
        float dy = polyline[i + 3] - polyline[i + 1];
        return dx * dx + dy * dy;
    }

    public static boolean intersectsRectangle(float[] polyline, float[] rectangle) {
        int numSegments = Geometry.numPoints(polyline) - 1;
        for (int iSegment = 0; iSegment < numSegments; ++iSegment) {
            if (!Polyline.segmentIntersectsRectangle(polyline, iSegment, rectangle)) continue;
            return true;
        }
        return false;
    }

    public static boolean segmentIntersectsRectangle(float[] polyline, int iSegment, float[] rectangle) {
        int i = iSegment * 2;
        return Polyline.segmentIntersectsRectangle(polyline[i], polyline[i + 1], polyline[i + 2], polyline[i + 3], rectangle);
    }

    public static boolean segmentIntersectsRectangle(float x1, float y1, float x2, float y2, float[] rectangle) {
        if (x1 < rectangle[0] && x2 < rectangle[0] || x1 > rectangle[2] && x2 > rectangle[2] || y1 < rectangle[1] && y2 < rectangle[1] || y1 > rectangle[3] && y2 > rectangle[3]) {
            return false;
        }
        if (Geometry.rectangleContainsPoint(rectangle, x1, y1)) {
            return true;
        }
        if (Geometry.rectangleContainsPoint(rectangle, x2, y2)) {
            return true;
        }
        float xm = (x1 + x2) / 2.0f;
        float ym = (y1 + y2) / 2.0f;
        return Polyline.segmentIntersectsRectangle(x1, y1, xm, ym, rectangle) || Polyline.segmentIntersectsRectangle(xm, ym, x2, y2, rectangle);
    }

    public static float[] projectPoint(float[] polyline, float[] point) {
        int numSegments = Geometry.numPoints(polyline) - 1;
        float bestDistSquared = Float.MAX_VALUE;
        float[] bestPoint = null;
        for (int iSegment = 0; iSegment < numSegments; ++iSegment) {
            int i = iSegment * 2;
            float[] p = Geometry.projectPointOnSegment(point[0], point[1], polyline[i], polyline[i + 1], polyline[i + 2], polyline[i + 3]);
            float distSquared = Geometry.distanceSquared(point, p);
            if (!(distSquared < bestDistSquared)) continue;
            bestDistSquared = distSquared;
            bestPoint = p;
        }
        return bestPoint;
    }

    public static int projectPointOnPolyline(float[] point, float[] polyline) {
        int numSegments = Geometry.numPoints(polyline) - 1;
        float bestDistSquared = Float.MAX_VALUE;
        float[] bestPoint = null;
        int projectedSegment = -1;
        for (int iSegment = 0; iSegment < numSegments; ++iSegment) {
            int i = iSegment * 2;
            float[] p = Geometry.projectPointOnSegment(point[0], point[1], polyline[i], polyline[i + 1], polyline[i + 2], polyline[i + 3]);
            float distSquared = Geometry.distanceSquared(point, p);
            if (!(distSquared < bestDistSquared)) continue;
            bestDistSquared = distSquared;
            bestPoint = p;
            projectedSegment = iSegment;
        }
        Geometry.copyPoints(bestPoint, point);
        return projectedSegment;
    }

    public static int findSmallSegment(float[] polyline, float threshold, int startIndex) {
        float threshold2 = threshold * threshold;
        float x2 = 0.0f;
        float y2 = 0.0f;
        int i = startIndex * 2;
        for (int j = i + 1; j < polyline.length; j += 2) {
            float x1 = x2;
            float y1 = y2;
            x2 = polyline[i];
            y2 = polyline[j];
            float dx = x2 - x1;
            float dy = y2 - y1;
            if (i > 0 && dx * dx + dy * dy <= threshold2) {
                return (i - 2) / 2;
            }
            i += 2;
        }
        return -1;
    }

    public static void movePointTo(float[] connectionPoints, float[] point, int index, float[] impactedRectangle) {
        Polyline.movePointTo(connectionPoints, point[0], point[1], index, impactedRectangle);
    }

    public static void movePointTo(float[] connectionPoints, float x, float y, int index, float[] impactedRectangle) {
        int i = index * 2;
        Geometry.rectangleMergeWithPoint(impactedRectangle, connectionPoints[i], connectionPoints[i + 1]);
        connectionPoints[i] = x;
        connectionPoints[i + 1] = y;
        Geometry.rectangleMergeWithPoint(impactedRectangle, x, y);
        if (i - 2 >= 0) {
            Geometry.rectangleMergeWithPoint(impactedRectangle, connectionPoints[i - 2], connectionPoints[i - 1]);
        }
        if (i + 3 < connectionPoints.length) {
            Geometry.rectangleMergeWithPoint(impactedRectangle, connectionPoints[i + 2], connectionPoints[i + 3]);
        }
    }

    public static float[] addEndSegment(float[] polyline, boolean start) {
        int length = polyline.length;
        float[] newPolyline = new float[length + 2];
        System.arraycopy(polyline, 0, newPolyline, start ? 2 : 0, length);
        if (start) {
            newPolyline[0] = polyline[0];
            newPolyline[1] = polyline[1];
        } else {
            newPolyline[length] = polyline[length - 2];
            newPolyline[length + 1] = polyline[length - 1];
        }
        return newPolyline;
    }

    public static float[] removeEndSegment(float[] polyline, boolean start) {
        int length = polyline.length;
        float[] newPolyline = new float[length - 2];
        System.arraycopy(polyline, start ? 2 : 0, newPolyline, 0, length - 2);
        return newPolyline;
    }

    public static float[] createPointOnSegment(float[] polyline, int segmentIndex) {
        float[] newPolyline = new float[polyline.length + 2];
        int newPointXIndex = segmentIndex * 2 + 2;
        float newPointX = (polyline[newPointXIndex - 2] + polyline[newPointXIndex]) / 2.0f;
        float newPointY = (polyline[newPointXIndex - 1] + polyline[newPointXIndex + 1]) / 2.0f;
        int i1 = 0;
        int i2 = 0;
        while (i1 < polyline.length) {
            if (i1 == newPointXIndex) {
                newPolyline[i2++] = newPointX;
                newPolyline[i2++] = newPointY;
            }
            newPolyline[i2] = polyline[i1];
            ++i1;
            ++i2;
        }
        return newPolyline;
    }

    public static float[] createPointPairOnSegment(float[] polyline, int segmentIndex) {
        float[] newPolyline = new float[polyline.length + 4];
        int newPointXIndex = segmentIndex * 2 + 2;
        float newPointX = (polyline[newPointXIndex - 2] + polyline[newPointXIndex]) / 2.0f;
        float newPointY = (polyline[newPointXIndex - 1] + polyline[newPointXIndex + 1]) / 2.0f;
        int i1 = 0;
        int i2 = 0;
        while (i1 < polyline.length) {
            if (i1 == newPointXIndex) {
                newPolyline[i2++] = newPointX;
                newPolyline[i2++] = newPointY;
                newPolyline[i2++] = newPointX;
                newPolyline[i2++] = newPointY;
            }
            newPolyline[i2] = polyline[i1];
            ++i1;
            ++i2;
        }
        return newPolyline;
    }
}

