/*
 * Decompiled with CFR 0.152.
 */
package obp.ui;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import obp.OBPModel;
import obp.cc.ConcreteContext;
import obp.cdl.CDLDeclaration;
import obp.partition.PathPartioner;
import obp.partition.SimplePartitioner;
import obp.transfo.cc.ConcreteContextExport;
import obp.transfo.cdl.CDLToConcreteContext;
import obp.ui.OBP;
import obp.util.ConcreteContextUtil;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.xid.basics.Basics;
import org.xid.basics.error.DiagnosticUtil;
import org.xid.basics.error.NumberValidator;
import org.xid.basics.error.Validator;
import org.xid.basics.generation.MergerUtil;
import org.xid.basics.notification.Notification;
import org.xid.basics.notification.NotificationListener;
import org.xid.basics.progress.ActionMonitor;
import org.xid.basics.ui.action.Action;
import org.xid.basics.ui.dialog.FieldDialog;
import org.xid.basics.ui.field.CheckboxField;
import org.xid.basics.ui.field.ChoiceField;
import org.xid.basics.ui.field.CompositeField;
import org.xid.basics.ui.field.Field;
import org.xid.basics.ui.field.ListField;
import org.xid.basics.ui.field.TextField;

public class ExportCDLAction
extends Action.Stub {
    private final OBP ui;
    private final OBPModel model;

    public ExportCDLAction(OBP ui, OBPModel model) {
        super("CDL\u2026");
        this.ui = ui;
        this.model = model;
    }

    public int getVisibility() {
        if (this.model.getCdl() == null) {
            return 2;
        }
        return this.model.getCdlList().size() > 0 ? 1 : 2;
    }

    public int run(ActionMonitor monitor) {
        ListField<CDLDeclaration> cdlListField = new ListField<CDLDeclaration>(null, 130){

            public String getText(CDLDeclaration element) {
                return element.getName();
            }
        };
        List<CDLDeclaration> cdlList = this.model.getCdlList();
        cdlListField.setValue(cdlList);
        cdlListField.setSingleSelection((Object)cdlList.get(0));
        final CheckboxField partitionField = new CheckboxField("Partition");
        final TextField parameterField = new TextField("Split parameter");
        parameterField.setValidator((Validator)new NumberValidator(2, "Invalid split paramexecutor.submiteter", Basics.POSITIVE | Basics.NOT_ZERO));
        parameterField.setIntValue(1);
        parameterField.setEnable(partitionField.getValue());
        final TextField directoryField = new TextField("Output directory");
        directoryField.setValidator((Validator)new Validator.Stub<String>(2, "Invalid output directory."){

            public boolean isValid(String value) {
                if (value == null) {
                    return false;
                }
                File file = new File(value);
                return file.exists() && file.isDirectory() && file.canWrite();
            }
        });
        directoryField.addAction((Action)new Action.Stub("\u2026"){

            public int run(ActionMonitor monitor) {
                DirectoryDialog dialog = new DirectoryDialog(ExportCDLAction.this.ui.getShell());
                dialog.setFilterPath(directoryField.getValue());
                String newDirectory = dialog.open();
                if (newDirectory == null) {
                    return 2;
                }
                directoryField.setValue(newDirectory);
                return 1;
            }
        });
        directoryField.setValue(this.model.getCdlFile().getParent());
        LinkedHashMap<String, String> extentions = new LinkedHashMap<String, String>();
        extentions.put("Simple", "scc");
        extentions.put("Dot", "dot");
        extentions.put("Scenario", "scn");
        extentions.put("Binary", "bcc");
        ChoiceField exportTypeField = new ChoiceField("Type", (Object)"Simple", new ArrayList(extentions.keySet()), 0);
        CompositeField cdlField = new CompositeField("CDL", 16, new Field[]{cdlListField});
        CompositeField optionField = new CompositeField("Options", 16, new Field[]{partitionField, parameterField});
        CompositeField outputField = new CompositeField("Output", 16, new Field[]{directoryField, exportTypeField});
        CompositeField mainField = new CompositeField(new Field[]{cdlField, optionField, outputField});
        FieldDialog dialog = new FieldDialog("CDLViewer", "Export CDL", 0, (Field)mainField);
        partitionField.addListener(new NotificationListener(){

            public void notified(Notification notification) {
                parameterField.setEnable(partitionField.getValue());
            }
        });
        NotificationListener countListener = new NotificationListener((ListField)cdlListField, parameterField, dialog){
            final /* synthetic */ ListField val$cdlListField;
            final /* synthetic */ TextField val$parameterField;
            final /* synthetic */ FieldDialog val$dialog;
            {
                this.val$cdlListField = listField;
                this.val$parameterField = textField;
                this.val$dialog = fieldDialog;
            }

            public void notified(Notification notification) {
                long lastCount = 0L;
                if (partitionField.getValue()) {
                    for (CDLDeclaration cdl : this.val$cdlListField.getChecked()) {
                        ConcreteContext completeCc = CDLToConcreteContext.toConcreteContext(ExportCDLAction.this.model.getCdlUnit(), cdl);
                        SimplePartitioner partitioner = new SimplePartitioner(completeCc, this.val$parameterField.getIntValue());
                        lastCount += partitioner.expectedPartitionCount();
                    }
                    StringBuilder message = new StringBuilder();
                    message.append(lastCount);
                    message.append(" partitions will be created.");
                    this.val$dialog.setInitialMessage(message.toString());
                } else {
                    this.val$dialog.setInitialMessage("");
                }
            }
        };
        mainField.addListener(countListener);
        if (dialog.open() != 0) {
            return 2;
        }
        String type = (String)exportTypeField.getValue();
        File outputDirectory = new File(directoryField.getValue());
        ExecutorService executor = Executors.newFixedThreadPool(10);
        for (CDLDeclaration cdl : cdlListField.getChecked()) {
            ConcreteContext completeCc = CDLToConcreteContext.toConcreteContext(this.model.getCdlUnit(), cdl);
            if (partitionField.getValue()) {
                SimplePartitioner partitioner = new SimplePartitioner(completeCc, parameterField.getIntValue());
                while (partitioner.hasNext()) {
                    ConcreteContext context = partitioner.next();
                    String name = context.getName() + "." + (String)extentions.get(type);
                    File destination = new File(outputDirectory, name);
                    executor.submit(this.saveFileRunnable(type, context, destination));
                }
                continue;
            }
            String name = completeCc.getName() + "." + (String)extentions.get(type);
            File destination = new File(outputDirectory, name);
            executor.submit(this.saveFileRunnable(type, completeCc, destination));
        }
        executor.shutdown();
        try {
            while (!executor.awaitTermination(250L, TimeUnit.MILLISECONDS)) {
            }
        }
        catch (InterruptedException e) {
            return 2;
        }
        return 1;
    }

    private Runnable saveFileRunnable(final String type, final ConcreteContext context, final File destination) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    if ("Simple".equals(type)) {
                        MergerUtil.writeFile((File)destination, (String)ConcreteContextExport.toSimple(context), (String)"UTF-8");
                    } else if ("Dot".equals(type)) {
                        MergerUtil.writeFile((File)destination, (String)ConcreteContextExport.toDot(context), (String)"UTF-8");
                    } else if ("Scenario".equals(type)) {
                        PathPartioner partioner = new PathPartioner(context);
                        MergerUtil.writeFile((File)destination, (String)ConcreteContextExport.toSimple(partioner.next()), (String)"UTF-8");
                    } else if ("Binary".equals(type)) {
                        ConcreteContextUtil.saveCC(context, destination);
                    }
                }
                catch (Exception e) {
                    ExportCDLAction.this.ui.error(DiagnosticUtil.createMessage((Throwable)e));
                }
            }
        };
    }
}

