/*
 * Decompiled with CFR 0.152.
 */
package obp.aut;

import java.util.HashSet;
import obp.aut.Aut;
import obp.aut.Edge;
import obp.states.Element;
import obp.states.Process;
import obp.states.State;
import obp.states.States;
import obp.states.Value;
import obp.states.ValueSimple;

public class LTSDotPrinter {
    public static String toDot(Aut aut) {
        StringBuilder dot = new StringBuilder();
        dot.append("digraph ");
        dot.append(aut.getName());
        dot.append(" { \n\trankdir=TB;\n");
        for (Edge edge : aut.getEdgeList()) {
            dot.append("\t");
            dot.append(edge.source);
            dot.append(" -> ");
            dot.append(edge.target);
            dot.append(" [label=\"");
            String label = edge.label.replaceAll("\n", "\\n");
            dot.append(label);
            dot.append("\"];\n");
        }
        dot.append("}\n");
        return dot.toString();
    }

    public static String toDot(Aut aut, States states) {
        StringBuilder dot = new StringBuilder();
        dot.append("strict digraph ");
        dot.append(aut.getName());
        dot.append(" { \n\trankdir=TB;\n");
        HashSet<State> statesToPrint = new HashSet<State>();
        for (Edge edge : aut.getEdgeList()) {
            dot.append("\t");
            dot.append(edge.source);
            dot.append(" -> ");
            dot.append(edge.target);
            dot.append(" [label=\"");
            String label = edge.label.replaceAll("\n", "\\n");
            dot.append(label);
            dot.append("\"];\n");
            statesToPrint.add(states.getState(edge.source));
            statesToPrint.add(states.getState(edge.target));
        }
        dot.append("\n");
        for (State state : statesToPrint) {
            dot.append("\t");
            dot.append(state.getId());
            dot.append(" [shape=box, label=\"");
            dot.append(state.getId());
            dot.append(" is\\n");
            for (Element element : state.getElementList()) {
                if (element instanceof Process) {
                    Process process = (Process)element;
                    dot.append(process.getPid());
                    dot.append(" ");
                    dot.append(process.getCurrentState());
                    if (process.getVariableList() != null) {
                        dot.append("[");
                        for (int i = 0; i < process.getVariableCount(); ++i) {
                            if (i > 0) {
                                dot.append(", ");
                            }
                            dot.append(process.getVariableList()[i].getName());
                            dot.append("=");
                            Value value = process.getVariableList()[i].getValue();
                            if (value instanceof ValueSimple) {
                                dot.append(((ValueSimple)value).getValue());
                                continue;
                            }
                            dot.append("?");
                        }
                        dot.append("]");
                    }
                }
                dot.append("\\n");
            }
            dot.append("\"];\n");
        }
        dot.append("}\n");
        return dot.toString();
    }
}

