/*
 * Decompiled with CFR 0.152.
 */
package spinja.promela.compiler.expression;

import java.util.HashSet;
import java.util.Set;
import spinja.promela.compiler.expression.Expression;
import spinja.promela.compiler.parser.MyParseException;
import spinja.promela.compiler.parser.ParseException;
import spinja.promela.compiler.parser.Token;
import spinja.promela.compiler.variable.VariableAccess;
import spinja.promela.compiler.variable.VariableType;

public class BooleanExpression
extends Expression {
    private static final long serialVersionUID = -4022528945025403911L;
    private final Expression ex1;
    private final Expression ex2;

    public BooleanExpression(Token token, Expression expression) {
        this(token, expression, null);
    }

    public BooleanExpression(Token token, Expression expression, Expression expression2) {
        super(token);
        this.ex1 = expression;
        this.ex2 = expression2;
    }

    @Override
    public String getBoolExpression() throws ParseException {
        if (this.ex2 == null) {
            return "(" + this.getToken().image + this.ex1.getBoolExpression() + ")";
        }
        return "(" + this.ex1.getBoolExpression() + " " + this.getToken().image + " " + this.ex2.getBoolExpression() + ")";
    }

    @Override
    public int getConstantValue() throws ParseException {
        switch (this.getToken().kind) {
            case 67: {
                return this.ex1.getConstantValue() == 0 ? 1 : 0;
            }
            case 85: {
                return this.ex1.getConstantValue() != 0 || this.ex2.getConstantValue() != 0 ? 1 : 0;
            }
            case 84: {
                return this.ex1.getConstantValue() != 0 && this.ex2.getConstantValue() != 0 ? 1 : 0;
            }
        }
        throw new MyParseException("Unimplemented aritmic type: " + this.getToken().image, this.getToken());
    }

    @Override
    public String getIntExpression() throws ParseException {
        if (this.ex2 == null) {
            return "(" + this.getToken().image + this.ex1.getIntExpression() + " ? 1 : 0)";
        }
        return "(" + this.ex1.getBoolExpression() + " " + this.getToken().image + " " + this.ex2.getBoolExpression() + " ? 1 : 0)";
    }

    @Override
    public VariableType getResultType() {
        return VariableType.BOOL;
    }

    @Override
    public String getSideEffect() throws ParseException {
        if (this.ex1.getSideEffect() != null || this.ex2 != null && this.ex2.getSideEffect() != null) {
            throw new MyParseException("No sideeffects allowed in a boolean expression!", this.getToken());
        }
        return null;
    }

    @Override
    public Set<VariableAccess> readVariables() {
        HashSet<VariableAccess> hashSet = new HashSet<VariableAccess>();
        if (this.ex1 != null) {
            hashSet.addAll(this.ex1.readVariables());
        }
        if (this.ex2 != null) {
            hashSet.addAll(this.ex2.readVariables());
        }
        return hashSet;
    }

    @Override
    public String toString() {
        try {
            return this.getBoolExpression();
        }
        catch (ParseException parseException) {
            return "";
        }
    }
}

