/*
 * Decompiled with CFR 0.152.
 */
package spinja.search;

public enum Message {
    DEADLOCK(4, "invalid end state"),
    NO_MORE_TRANSITIONS(0, "no more transitions to take"),
    TRANS_ERROR(4, "transition error"),
    EXCEED_DEPTH_ERROR(4, "exceeded maximum depth"),
    EXCEED_DEPTH_WARNING(2, "exceeded maximum depth"),
    DUPLICATE_STATE(0, "duplicate state found");

    private final int errorLevel;
    private final String defaultMessage;
    private byte[] state;

    private Message(int n2, String string2) {
        this.errorLevel = n2;
        this.defaultMessage = string2;
    }

    public boolean isError() {
        return this.errorLevel >= 4;
    }

    public boolean isWarning() {
        return this.errorLevel >= 2;
    }

    public String getDefaultMessage() {
        return this.defaultMessage;
    }

    public Message withState(byte[] byArray) {
        this.state = byArray;
        return this;
    }

    public byte[] getState() {
        return this.state;
    }
}

