/*
 * Decompiled with CFR 0.152.
 */
package org.cte.ABCD;

import java.util.Stack;
import org.cte.ABCD.ABCDVisitor;
import org.cte.ABCD.model.declarations.ABCDSystem;
import org.cte.ABCD.model.declarations.ArgumentMap;
import org.cte.ABCD.model.declarations.Asynchronous;
import org.cte.ABCD.model.declarations.ChannelDecl;
import org.cte.ABCD.model.declarations.ChannelTypeDecl;
import org.cte.ABCD.model.declarations.ConstantDecl;
import org.cte.ABCD.model.declarations.EventPool;
import org.cte.ABCD.model.declarations.Field;
import org.cte.ABCD.model.declarations.FunctionDecl;
import org.cte.ABCD.model.declarations.ParameterDecl;
import org.cte.ABCD.model.declarations.Port;
import org.cte.ABCD.model.declarations.PortMap;
import org.cte.ABCD.model.declarations.ProcessDecl;
import org.cte.ABCD.model.declarations.ProcessInstance;
import org.cte.ABCD.model.declarations.State;
import org.cte.ABCD.model.declarations.Synchronous;
import org.cte.ABCD.model.declarations.TypeDecl;
import org.cte.ABCD.model.declarations.VariableDecl;
import org.cte.ABCD.model.expressions.Any;
import org.cte.ABCD.model.expressions.ArrayLit;
import org.cte.ABCD.model.expressions.BinaryExp;
import org.cte.ABCD.model.expressions.FalseLit;
import org.cte.ABCD.model.expressions.FieldLiteral;
import org.cte.ABCD.model.expressions.FunctionCall;
import org.cte.ABCD.model.expressions.IndexedExp;
import org.cte.ABCD.model.expressions.IntegerLit;
import org.cte.ABCD.model.expressions.QueueLit;
import org.cte.ABCD.model.expressions.RecordLit;
import org.cte.ABCD.model.expressions.Reference;
import org.cte.ABCD.model.expressions.SelectedExp;
import org.cte.ABCD.model.expressions.TrueLit;
import org.cte.ABCD.model.expressions.UnaryExp;
import org.cte.ABCD.model.expressions.UnionLiteral;
import org.cte.ABCD.model.kernel.Element;
import org.cte.ABCD.model.kernel.Expression;
import org.cte.ABCD.model.kernel.Statement;
import org.cte.ABCD.model.kernel.Type;
import org.cte.ABCD.model.statements.AssignStmt;
import org.cte.ABCD.model.statements.Block;
import org.cte.ABCD.model.statements.CaseItem;
import org.cte.ABCD.model.statements.CaseStmt;
import org.cte.ABCD.model.statements.DeferredEvent;
import org.cte.ABCD.model.statements.ForeachStmt;
import org.cte.ABCD.model.statements.GuardStmt;
import org.cte.ABCD.model.statements.IfStmt;
import org.cte.ABCD.model.statements.InputStmt;
import org.cte.ABCD.model.statements.LoopStmt;
import org.cte.ABCD.model.statements.NullStmt;
import org.cte.ABCD.model.statements.OutputStmt;
import org.cte.ABCD.model.statements.ReceiveStmt;
import org.cte.ABCD.model.statements.ReturnStmt;
import org.cte.ABCD.model.statements.SelectStmt;
import org.cte.ABCD.model.statements.SendStmt;
import org.cte.ABCD.model.statements.SpecialTypeStmt;
import org.cte.ABCD.model.statements.ToStmt;
import org.cte.ABCD.model.statements.Transition;
import org.cte.ABCD.model.statements.WaitStmt;
import org.cte.ABCD.model.statements.WhileStmt;
import org.cte.ABCD.model.types.Array;
import org.cte.ABCD.model.types.BoolType;
import org.cte.ABCD.model.types.IntType;
import org.cte.ABCD.model.types.Interval;
import org.cte.ABCD.model.types.MutexType;
import org.cte.ABCD.model.types.NatType;
import org.cte.ABCD.model.types.NoneType;
import org.cte.ABCD.model.types.Queue;
import org.cte.ABCD.model.types.Record;
import org.cte.ABCD.model.types.SemaphoreType;
import org.cte.ABCD.model.types.TimerType;
import org.cte.ABCD.model.types.Union;

public class ABCDWalker
implements ABCDVisitor {
    private final ABCDVisitor delegate;
    private final Stack<Element> parentStack = new Stack();

    public ABCDWalker(ABCDVisitor delegate) {
        this.delegate = delegate;
    }

    public Stack<Element> getParentStack() {
        return this.parentStack;
    }

    @Override
    public void visitBoolType(BoolType toVisit) {
        this.parentStack.push(toVisit);
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitNatType(NatType toVisit) {
        this.parentStack.push(toVisit);
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitIntType(IntType toVisit) {
        this.parentStack.push(toVisit);
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitNoneType(NoneType toVisit) {
        this.parentStack.push(toVisit);
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitTimerType(TimerType toVisit) {
        this.parentStack.push(toVisit);
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitSemaphoreType(SemaphoreType toVisit) {
        this.parentStack.push(toVisit);
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitMutexType(MutexType toVisit) {
        this.parentStack.push(toVisit);
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitInterval(Interval toVisit) {
        this.parentStack.push(toVisit);
        if (toVisit.getMini() != null) {
            toVisit.getMini().accept(this);
        }
        if (toVisit.getMaxi() != null) {
            toVisit.getMaxi().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitUnion(Union toVisit) {
        this.parentStack.push(toVisit);
        for (Field child : toVisit.getFieldsList()) {
            child.accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitRecord(Record toVisit) {
        this.parentStack.push(toVisit);
        for (Field child : toVisit.getFieldsList()) {
            child.accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitArray(Array toVisit) {
        this.parentStack.push(toVisit);
        if (toVisit.getSize() != null) {
            toVisit.getSize().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitQueue(Queue toVisit) {
        this.parentStack.push(toVisit);
        if (toVisit.getSize() != null) {
            toVisit.getSize().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitTypeDecl(TypeDecl toVisit) {
        this.parentStack.push(toVisit);
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitField(Field toVisit) {
        this.parentStack.push(toVisit);
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitSynchronous(Synchronous toVisit) {
        this.parentStack.push(toVisit);
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitAsynchronous(Asynchronous toVisit) {
        this.parentStack.push(toVisit);
        if (toVisit.getSize() != null) {
            toVisit.getSize().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitEventPool(EventPool toVisit) {
        this.parentStack.push(toVisit);
        if (toVisit.getSize() != null) {
            toVisit.getSize().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitChannelTypeDecl(ChannelTypeDecl toVisit) {
        this.parentStack.push(toVisit);
        if (toVisit.getSynchronizationPolicy() != null) {
            toVisit.getSynchronizationPolicy().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitConstantDecl(ConstantDecl toVisit) {
        this.parentStack.push(toVisit);
        if (toVisit.getValue() != null) {
            toVisit.getValue().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitVariableDecl(VariableDecl toVisit) {
        this.parentStack.push(toVisit);
        if (toVisit.getValue() != null) {
            toVisit.getValue().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitParameterDecl(ParameterDecl toVisit) {
        this.parentStack.push(toVisit);
        if (toVisit.getValue() != null) {
            toVisit.getValue().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitChannelDecl(ChannelDecl toVisit) {
        this.parentStack.push(toVisit);
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitPort(Port toVisit) {
        this.parentStack.push(toVisit);
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitProcessDecl(ProcessDecl toVisit) {
        this.parentStack.push(toVisit);
        for (Port port : toVisit.getPortsList()) {
            port.accept(this);
        }
        for (ParameterDecl parameterDecl : toVisit.getParametersList()) {
            parameterDecl.accept(this);
        }
        for (VariableDecl variableDecl : toVisit.getVariablesList()) {
            variableDecl.accept(this);
        }
        for (Transition transition : toVisit.getTransitionsList()) {
            transition.accept(this);
        }
        for (State state : toVisit.getStatesList()) {
            state.accept(this);
        }
        if (toVisit.getInitialization() != null) {
            toVisit.getInitialization().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitFunctionDecl(FunctionDecl toVisit) {
        this.parentStack.push(toVisit);
        for (ParameterDecl parameterDecl : toVisit.getParametersList()) {
            parameterDecl.accept(this);
        }
        for (VariableDecl variableDecl : toVisit.getVariablesList()) {
            variableDecl.accept(this);
        }
        if (toVisit.getBody() != null) {
            toVisit.getBody().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitState(State toVisit) {
        this.parentStack.push(toVisit);
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitPortMap(PortMap toVisit) {
        this.parentStack.push(toVisit);
        if (toVisit.getActual() != null) {
            toVisit.getActual().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitArgumentMap(ArgumentMap toVisit) {
        this.parentStack.push(toVisit);
        if (toVisit.getActual() != null) {
            toVisit.getActual().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitProcessInstance(ProcessInstance toVisit) {
        this.parentStack.push(toVisit);
        for (ArgumentMap argumentMap : toVisit.getArgumentsList()) {
            argumentMap.accept(this);
        }
        for (PortMap portMap : toVisit.getInputsList()) {
            portMap.accept(this);
        }
        for (PortMap portMap : toVisit.getOutputsList()) {
            portMap.accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitABCDSystem(ABCDSystem toVisit) {
        this.parentStack.push(toVisit);
        for (ConstantDecl constantDecl : toVisit.getConstantsList()) {
            constantDecl.accept(this);
        }
        for (VariableDecl variableDecl : toVisit.getVariablesList()) {
            variableDecl.accept(this);
        }
        for (Type type : toVisit.getCoreTypesList()) {
            type.accept(this);
        }
        for (TypeDecl typeDecl : toVisit.getTypesList()) {
            typeDecl.accept(this);
        }
        for (ChannelTypeDecl channelTypeDecl : toVisit.getChannelTypesList()) {
            channelTypeDecl.accept(this);
        }
        for (ChannelDecl channelDecl : toVisit.getChannelsList()) {
            channelDecl.accept(this);
        }
        for (FunctionDecl functionDecl : toVisit.getFunctionsList()) {
            functionDecl.accept(this);
        }
        for (ProcessDecl processDecl : toVisit.getProcessesList()) {
            processDecl.accept(this);
        }
        for (ProcessInstance processInstance : toVisit.getCompositionList()) {
            processInstance.accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitInputStmt(InputStmt toVisit) {
        this.parentStack.push(toVisit);
        if (toVisit.getExpression() != null) {
            toVisit.getExpression().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitOutputStmt(OutputStmt toVisit) {
        this.parentStack.push(toVisit);
        if (toVisit.getExpression() != null) {
            toVisit.getExpression().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitSendStmt(SendStmt toVisit) {
        this.parentStack.push(toVisit);
        if (toVisit.getExpression() != null) {
            toVisit.getExpression().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitReceiveStmt(ReceiveStmt toVisit) {
        this.parentStack.push(toVisit);
        if (toVisit.getExpression() != null) {
            toVisit.getExpression().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitToStmt(ToStmt toVisit) {
        this.parentStack.push(toVisit);
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitLoopStmt(LoopStmt toVisit) {
        this.parentStack.push(toVisit);
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitIfStmt(IfStmt toVisit) {
        this.parentStack.push(toVisit);
        if (toVisit.getCondition() != null) {
            toVisit.getCondition().accept(this);
        }
        if (toVisit.getTrueBranch() != null) {
            toVisit.getTrueBranch().accept(this);
        }
        if (toVisit.getFalseBranch() != null) {
            toVisit.getFalseBranch().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitSelectStmt(SelectStmt toVisit) {
        this.parentStack.push(toVisit);
        for (Statement child : toVisit.getStatementsList()) {
            child.accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitSpecialTypeStmt(SpecialTypeStmt toVisit) {
        this.parentStack.push(toVisit);
        for (Expression child : toVisit.getArgumentsList()) {
            child.accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitWaitStmt(WaitStmt toVisit) {
        this.parentStack.push(toVisit);
        if (toVisit.getMinBound() != null) {
            toVisit.getMinBound().accept(this);
        }
        if (toVisit.getMaxBound() != null) {
            toVisit.getMaxBound().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitAssignStmt(AssignStmt toVisit) {
        this.parentStack.push(toVisit);
        if (toVisit.getLhs() != null) {
            toVisit.getLhs().accept(this);
        }
        if (toVisit.getRhs() != null) {
            toVisit.getRhs().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitDeferredEvent(DeferredEvent toVisit) {
        this.parentStack.push(toVisit);
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitTransition(Transition toVisit) {
        this.parentStack.push(toVisit);
        for (DeferredEvent child : toVisit.getDeferredEventsList()) {
            child.accept(this);
        }
        if (toVisit.getBehavior() != null) {
            toVisit.getBehavior().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitBlock(Block toVisit) {
        this.parentStack.push(toVisit);
        for (Statement child : toVisit.getStatementsList()) {
            child.accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitWhileStmt(WhileStmt toVisit) {
        this.parentStack.push(toVisit);
        if (toVisit.getCondition() != null) {
            toVisit.getCondition().accept(this);
        }
        if (toVisit.getBody() != null) {
            toVisit.getBody().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitForeachStmt(ForeachStmt toVisit) {
        this.parentStack.push(toVisit);
        if (toVisit.getVariable() != null) {
            toVisit.getVariable().accept(this);
        }
        if (toVisit.getBody() != null) {
            toVisit.getBody().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitNullStmt(NullStmt toVisit) {
        this.parentStack.push(toVisit);
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitReturnStmt(ReturnStmt toVisit) {
        this.parentStack.push(toVisit);
        if (toVisit.getExpression() != null) {
            toVisit.getExpression().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitCaseStmt(CaseStmt toVisit) {
        this.parentStack.push(toVisit);
        for (CaseItem child : toVisit.getItemsList()) {
            child.accept(this);
        }
        if (toVisit.getExpression() != null) {
            toVisit.getExpression().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitCaseItem(CaseItem toVisit) {
        this.parentStack.push(toVisit);
        if (toVisit.getExpression() != null) {
            toVisit.getExpression().accept(this);
        }
        if (toVisit.getBlock() != null) {
            toVisit.getBlock().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitGuardStmt(GuardStmt toVisit) {
        this.parentStack.push(toVisit);
        if (toVisit.getExpression() != null) {
            toVisit.getExpression().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitIntegerLit(IntegerLit toVisit) {
        this.parentStack.push(toVisit);
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitTrueLit(TrueLit toVisit) {
        this.parentStack.push(toVisit);
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitFalseLit(FalseLit toVisit) {
        this.parentStack.push(toVisit);
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitRecordLit(RecordLit toVisit) {
        this.parentStack.push(toVisit);
        for (FieldLiteral child : toVisit.getValueList()) {
            child.accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitFieldLiteral(FieldLiteral toVisit) {
        this.parentStack.push(toVisit);
        if (toVisit.getValue() != null) {
            toVisit.getValue().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitUnionLiteral(UnionLiteral toVisit) {
        this.parentStack.push(toVisit);
        if (toVisit.getExpression() != null) {
            toVisit.getExpression().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitArrayLit(ArrayLit toVisit) {
        this.parentStack.push(toVisit);
        for (Expression child : toVisit.getValueList()) {
            child.accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitQueueLit(QueueLit toVisit) {
        this.parentStack.push(toVisit);
        for (Expression child : toVisit.getValueList()) {
            child.accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitUnaryExp(UnaryExp toVisit) {
        this.parentStack.push(toVisit);
        if (toVisit.getOperand() != null) {
            toVisit.getOperand().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitBinaryExp(BinaryExp toVisit) {
        this.parentStack.push(toVisit);
        for (Expression child : toVisit.getOperandsList()) {
            child.accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitIndexedExp(IndexedExp toVisit) {
        this.parentStack.push(toVisit);
        if (toVisit.getPrefix() != null) {
            toVisit.getPrefix().accept(this);
        }
        if (toVisit.getIndex() != null) {
            toVisit.getIndex().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitSelectedExp(SelectedExp toVisit) {
        this.parentStack.push(toVisit);
        if (toVisit.getPrefix() != null) {
            toVisit.getPrefix().accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitReference(Reference toVisit) {
        this.parentStack.push(toVisit);
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitFunctionCall(FunctionCall toVisit) {
        this.parentStack.push(toVisit);
        for (ArgumentMap child : toVisit.getArgumentsList()) {
            child.accept(this);
        }
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }

    @Override
    public void visitAny(Any toVisit) {
        this.parentStack.push(toVisit);
        this.parentStack.pop();
        toVisit.accept(this.delegate);
    }
}

