/*
 * Decompiled with CFR 0.152.
 */
package obp.interpreter.runtime;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import obp.explorer.runtime.BehaviorConfiguration;
import obp.explorer.runtime.Configuration;
import obp.explorer.runtime.ExplorationContext;
import obp.explorer.runtime.ProcessBehavior;
import obp.explorer.runtime.SymbolsTable;
import obp.explorer.runtime.core.Transition;
import obp.interpreter.IBehavior;
import obp.interpreter.ITransition;
import obp.interpreter.runtime.BehaviorConfigurationImpl;
import obp.interpreter.runtime.InterpreterContext;
import obp.interpreter.runtime.TransitionImpl;
import obp.lua.LuaUtil;
import org.luaj.vm2.LuaValue;
import org.xid.basics.serializer.Boost;

public class BehaviorImpl
extends ProcessBehavior {
    private final String[] valueNames;
    private final LuaValue[] initialValues;
    private final TransitionImpl[] transitions;

    public BehaviorImpl(InterpreterContext context, IBehavior behavior) throws IOException {
        super(behavior.getName(), context.getSymbols());
        int i;
        this.valueNames = new String[behavior.getValueCount()];
        for (i = 0; i < this.valueNames.length; ++i) {
            this.valueNames[i] = behavior.getValue(i);
        }
        this.initialValues = new LuaValue[behavior.getInitializerCount()];
        for (i = 0; i < this.valueNames.length; ++i) {
            this.initialValues[i] = LuaUtil.evalExpression(behavior.getInitializer(i), context.getLua());
        }
        if (this.valueNames.length != this.initialValues.length) {
            throw new IOException("Excepting " + this.valueNames.length + " initializers but had " + this.initialValues.length + " instead.");
        }
        List<ITransition> transitionList = behavior.getTransitionList();
        this.transitions = new TransitionImpl[transitionList.size()];
        for (int i2 = 0; i2 < this.transitions.length; ++i2) {
            this.transitions[i2] = context.createTransition(behavior, this.id, transitionList.get(i2));
        }
    }

    @Override
    public void link(ExplorationContext context, SymbolsTable symbols) {
        for (TransitionImpl transition : this.transitions) {
            transition.prepare();
        }
    }

    @Override
    public Transition[] getTransitions(Configuration configuration) {
        return this.transitions;
    }

    @Override
    public BehaviorConfiguration createInitialConfiguration(Configuration conf) {
        BehaviorConfigurationImpl init = new BehaviorConfigurationImpl();
        init.values = Arrays.copyOf(this.initialValues, this.initialValues.length);
        return init;
    }

    @Override
    public BehaviorConfiguration readConfiguration(Boost boost) {
        BehaviorConfigurationImpl iBehaviorConfiguration = new BehaviorConfigurationImpl();
        int length = boost.readInt();
        iBehaviorConfiguration.values = new LuaValue[length];
        for (int i = 0; i < iBehaviorConfiguration.values.length; ++i) {
            iBehaviorConfiguration.values[i] = LuaUtil.readFromBoost(boost);
        }
        return iBehaviorConfiguration;
    }

    @Override
    public void writeConfiguration(Boost boost, BehaviorConfiguration behaviorConfiguration) {
        BehaviorConfigurationImpl iBehaviorConfiguration = (BehaviorConfigurationImpl)behaviorConfiguration;
        boost.writeInt(iBehaviorConfiguration.values.length);
        for (int i = 0; i < iBehaviorConfiguration.values.length; ++i) {
            LuaUtil.writeToBoost(iBehaviorConfiguration.values[i], boost);
        }
    }

    @Override
    public String toStringConfiguration(BehaviorConfiguration behaviorConfiguration) {
        BehaviorConfigurationImpl iBehaviorConfiguration = (BehaviorConfigurationImpl)behaviorConfiguration;
        StringBuilder text = new StringBuilder();
        text.append("'");
        text.append(this.name);
        text.append("' [");
        for (int i = 0; i < this.valueNames.length; ++i) {
            text.append("\n\t- ");
            text.append(this.valueNames[i]);
            text.append("=");
            text.append(LuaUtil.toString(iBehaviorConfiguration.values[i]));
        }
        text.append("\n]");
        return text.toString();
    }

    @Override
    public String toDotStringConfiguration(BehaviorConfiguration behaviorConfiguration) {
        BehaviorConfigurationImpl iBehaviorConfiguration = (BehaviorConfigurationImpl)behaviorConfiguration;
        StringBuilder text = new StringBuilder();
        text.append("'");
        text.append(this.name);
        text.append("' [");
        int length = text.length();
        for (int i = 0; i < this.valueNames.length; ++i) {
            if (text.length() > length) {
                text.append("\\n");
            }
            text.append(this.valueNames[i]);
            text.append("=");
            text.append(LuaUtil.toString(iBehaviorConfiguration.values[i]));
        }
        text.append("]");
        return text.toString();
    }
}

