/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import obp.fiacre.model.ModelVisitor;
import obp.fiacre.model.Statement;
import org.xid.basics.serializer.Boost;
import org.xid.basics.serializer.BoostObject;
import org.xid.basics.serializer.BoostUtil;

public class Select
implements BoostObject,
Statement {
    private final List<Statement> statementList = new ArrayList<Statement>();
    private final List<String> commentList = new ArrayList<String>();

    public Select() {
    }

    protected Select(Boost boost) {
        boost.register((BoostObject)this);
        for (Statement oneChild : BoostUtil.readObjectList((Boost)boost, Statement.class)) {
            this.statementList.add(oneChild);
        }
        for (String oneChild : BoostUtil.readStringArray((Boost)boost)) {
            this.commentList.add(oneChild);
        }
    }

    public List<Statement> getStatementList() {
        return Collections.unmodifiableList(this.statementList);
    }

    public int getStatementCount() {
        return this.statementList.size();
    }

    public Statement getStatement(int index) {
        if (index < 0 || index >= this.getStatementCount()) {
            return null;
        }
        return this.statementList.get(index);
    }

    public void addStatement(Statement newValue) {
        this.addStatement(this.getStatementCount(), newValue);
    }

    public void addStatement(int index, Statement newValue) {
        this.statementList.add(index, newValue);
    }

    public Statement setStatement(int index, Statement newValue) {
        return this.statementList.set(index, newValue);
    }

    public void addAllStatement(Collection<Statement> toAddList) {
        for (Statement newValue : toAddList) {
            this.addStatement(this.getStatementCount(), newValue);
        }
    }

    public void removeStatement(Statement value) {
        int index = this.statementList.indexOf(value);
        if (index >= 0) {
            this.removeStatement(index);
        }
    }

    public void removeStatement(int index) {
        this.statementList.remove(index);
    }

    @Override
    public List<String> getCommentList() {
        return Collections.unmodifiableList(this.commentList);
    }

    @Override
    public int getCommentCount() {
        return this.commentList.size();
    }

    @Override
    public String getComment(int index) {
        if (index < 0 || index >= this.getCommentCount()) {
            return null;
        }
        return this.commentList.get(index);
    }

    @Override
    public void addComment(String newValue) {
        this.addComment(this.getCommentCount(), newValue);
    }

    @Override
    public void addComment(int index, String newValue) {
        this.commentList.add(index, newValue);
    }

    @Override
    public String setComment(int index, String newValue) {
        return this.commentList.set(index, newValue);
    }

    @Override
    public void addAllComment(Collection<String> toAddList) {
        for (String newValue : toAddList) {
            this.addComment(this.getCommentCount(), newValue);
        }
    }

    @Override
    public void removeComment(String value) {
        int index = this.commentList.indexOf(value);
        if (index >= 0) {
            this.removeComment(index);
        }
    }

    @Override
    public void removeComment(int index) {
        this.commentList.remove(index);
    }

    public void writeToBoost(Boost boost) {
        BoostUtil.writeObjectCollection((Boost)boost, this.statementList);
        BoostUtil.writeStringCollection((Boost)boost, this.commentList);
    }

    @Override
    public void accept(ModelVisitor visitor) {
        visitor.visitSelect(this);
    }
}

