/*
 * Decompiled with CFR 0.152.
 */
package properties.LTL.transformations;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import properties.BuchiAutomata.BuchiAutomataModel.Automaton;
import properties.BuchiAutomata.BuchiAutomataModel.Buchi;
import properties.BuchiAutomata.BuchiAutomataModel.BuchiAutomataModelFactory;
import properties.BuchiAutomata.BuchiAutomataModel.BuchiDeclaration;
import properties.BuchiAutomata.BuchiAutomataModel.GuardedTransition;
import properties.BuchiAutomata.BuchiAutomataModel.State;
import properties.LTL.ltl3ba.LTL3BA;
import properties.LTL.transformations.LTL2AbstractText;
import properties.PropositionalLogic.PropositionalLogicModel.Expression;
import properties.PropositionalLogic.PropositionalLogicModel.ExpressionDeclaration;
import properties.PropositionalLogic.PropositionalLogicModel.ExpressionReference;
import properties.PropositionalLogic.PropositionalLogicModel.LetExpression;
import properties.PropositionalLogic.PropositionalLogicModel.LogicalConjunction;
import properties.PropositionalLogic.PropositionalLogicModel.LogicalNegation;
import properties.PropositionalLogic.PropositionalLogicModel.PropositionalLogicModelFactory;

public class LTL2Buchi {
    private final PrintWriter out;
    PropositionalLogicModelFactory pFactory = PropositionalLogicModelFactory.eINSTANCE;
    BuchiAutomataModelFactory bFactory = BuchiAutomataModelFactory.eINSTANCE;

    public LTL2Buchi(PrintWriter out) {
        this.out = out == null ? new PrintWriter(System.out) : out;
    }

    public BuchiDeclaration convert(Expression exp) {
        LTL2AbstractText.AbstractFormula absFormula = new LTL2AbstractText().convert(exp);
        this.out.println("\n\nTransforming LTL formula : !" + absFormula.formula);
        this.out.flush();
        List transitions = LTL3BA.transform((String)("!(" + absFormula.formula + ")"));
        Map<String, ExpressionDeclaration> atomMap = absFormula.atoms.entrySet().stream().collect(Collectors.toMap(p -> (String)p.getKey(), p -> {
            ExpressionDeclaration eD = this.pFactory.createExpressionDeclaration();
            eD.setName((String)p.getKey());
            eD.setExpression((Expression)EcoreUtil.copy((EObject)((EObject)p.getValue())));
            return eD;
        }));
        Automaton buchi = this.readBuchiFromSpot(transitions, atomMap);
        BuchiDeclaration result = this.bFactory.createBuchiDeclaration();
        result.getDeclarations().addAll(atomMap.values());
        result.setAutomaton((Buchi)buchi);
        return result;
    }

    public Automaton convert(String exp) {
        this.out.println("\n\nTransforming LTL formula : " + exp);
        this.out.flush();
        List transitions = LTL3BA.transform((String)exp);
        return this.readBuchiFromSpot(transitions, null);
    }

    Automaton readBuchiFromSpot(List<String[]> transitions, Map<String, ExpressionDeclaration> atomMap) {
        HashMap<String, State> name2state = new HashMap<String, State>();
        Automaton automaton = this.bFactory.createAutomaton();
        for (String[] transition : transitions) {
            State target;
            State source = (State)name2state.get(transition[0]);
            if (source == null) {
                source = this.createState(transition[0]);
                name2state.put(transition[0], source);
                automaton.getStates().add((Object)source);
                if (transition[0].endsWith("init")) {
                    automaton.setInitial(source);
                }
            }
            if ((target = (State)name2state.get(transition[1])) == null) {
                target = this.createState(transition[1]);
                name2state.put(transition[1], target);
                automaton.getStates().add((Object)target);
            }
            Expression guard = this.parsePredicateFromSpot(transition[2], atomMap);
            GuardedTransition buchiTransition = this.bFactory.createGuardedTransition();
            buchiTransition.setFrom(source);
            buchiTransition.setTo(target);
            if (guard != null) {
                LetExpression letE = this.pFactory.createLetExpression();
                if (atomMap != null) {
                    letE.getDeclarations().addAll(EcoreUtil.copyAll(atomMap.values()));
                }
                letE.setExpression(guard);
                buchiTransition.setGuard((Expression)letE);
            }
            automaton.getTransitions().add((Object)buchiTransition);
        }
        return automaton;
    }

    State createState(String name) {
        Object state = name.startsWith("accept") ? this.bFactory.createAcceptingState() : this.bFactory.createState();
        state.setName(name);
        return state;
    }

    Expression parsePredicateFromSpot(final String guardString, final Map<String, ExpressionDeclaration> atomMap) {
        class Parser {
            int position = 0;

            Parser() {
            }

            void next() {
                ++this.position;
                while (this.position < guardString.length() && Character.isWhitespace(this.getChar())) {
                    ++this.position;
                }
            }

            Expression parse() {
                if (guardString.equals("true")) {
                    return LTL2Buchi.this.pFactory.createTrue();
                }
                return this.parseExpression();
            }

            Expression parseExpression() {
                Expression lhs = this.parseUnary();
                while (this.position < guardString.length()) {
                    LogicalConjunction predicate;
                    Expression rhs;
                    if (this.getChar() == '&') {
                        this.next();
                        if (this.getChar() != '&') {
                            throw new RuntimeException("expected '&&' but found '&" + this.getChar() + "'");
                        }
                        this.next();
                        rhs = this.parseUnary();
                        predicate = LTL2Buchi.this.pFactory.createLogicalConjunction();
                        predicate.setOperatorToken("&&");
                        predicate.setLhs(lhs);
                        predicate.setRhs(rhs);
                        lhs = predicate;
                        continue;
                    }
                    if (this.getChar() == '|') {
                        this.next();
                        if (this.getChar() != '|') {
                            throw new RuntimeException("expected '||' but found '|" + this.getChar() + "'");
                        }
                        this.next();
                        rhs = this.parseUnary();
                        predicate = LTL2Buchi.this.pFactory.createLogicalDisjunction();
                        predicate.setOperatorToken("||");
                        predicate.setLhs(lhs);
                        predicate.setRhs(rhs);
                        lhs = predicate;
                        continue;
                    }
                    return lhs;
                }
                return lhs;
            }

            Expression parseUnary() {
                Expression result;
                boolean negation = false;
                if (this.getChar() == '!') {
                    this.next();
                    negation = true;
                }
                if (this.getChar() == '(') {
                    this.next();
                    result = this.parseExpression();
                    if (this.getChar() == ')') {
                        this.next();
                    }
                } else {
                    StringBuilder identSB = new StringBuilder();
                    while (this.getChar() >= 'a' && this.getChar() <= 'z' || this.getChar() >= '0' && this.getChar() <= '9' || this.getChar() == '_') {
                        identSB.append(this.getChar());
                        this.next();
                    }
                    if (identSB.length() == 0) {
                        throw new RuntimeException("unexpected character " + this.getChar() + " in buchi guard expression");
                    }
                    ExpressionReference reference = LTL2Buchi.this.pFactory.createExpressionReference();
                    reference.setName(identSB.toString());
                    if (atomMap != null) {
                        String name = identSB.toString();
                        ExpressionDeclaration decl = (ExpressionDeclaration)atomMap.get(name);
                        reference.setExp(decl);
                    }
                    result = reference;
                }
                if (negation) {
                    LogicalNegation predicate = LTL2Buchi.this.pFactory.createLogicalNegation();
                    predicate.setOperatorToken("!");
                    predicate.setOperand(result);
                    return predicate;
                }
                return result;
            }

            private char getChar() {
                return guardString.charAt(this.position);
            }
        }
        return new Parser().parse();
    }
}

