/*
 * Decompiled with CFR 0.152.
 */
package tuml.interpreter;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Type;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Pure;
import tuml.interpreter.ActiveObject;
import tuml.interpreter.Environment;
import tuml.interpreter.IAbstractVisitor;

public class Composite {
    private final Environment env;
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private final Class c;
    private final HashMap<String, ActiveObject> parts = new HashMap();

    public Composite(final Environment env, Class c) {
        this.env = env;
        this.c = c;
        EList _ownedAttributes = c.getOwnedAttributes();
        Functions.Function1<Property, Boolean> _function = new Functions.Function1<Property, Boolean>(){

            public Boolean apply(Property it) {
                return Composite.isProcessInstance(it);
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_ownedAttributes, (Functions.Function1)_function);
        Consumer<Property> _function_1 = new Consumer<Property>(){

            @Override
            public void accept(Property part) {
                String _name = part.getName();
                Type _type = part.getType();
                String _name_1 = part.getName();
                ActiveObject _activeObject = new ActiveObject(env, (Class)_type, _name_1);
                Composite.this.parts.put(_name, _activeObject);
            }
        };
        _filter.forEach(_function_1);
        EList _ownedConnectors = c.getOwnedConnectors();
        Consumer<Connector> _function_2 = new Consumer<Connector>(){

            @Override
            public void accept(Connector con) {
                Property _definingEnd_2;
                Class _class__1;
                boolean _notEquals_1;
                boolean _notEquals;
                EList _ends = con.getEnds();
                ConnectorEnd end1 = (ConnectorEnd)_ends.get(0);
                ConnectableElement _role = end1.getRole();
                String _name = _role.getName();
                ActiveObject ao1 = (ActiveObject)Composite.this.parts.get(_name);
                EList _ends_1 = con.getEnds();
                ConnectorEnd end2 = (ConnectorEnd)_ends_1.get(1);
                ConnectableElement _role_1 = end2.getRole();
                String _name_1 = _role_1.getName();
                ActiveObject ao2 = (ActiveObject)Composite.this.parts.get(_name_1);
                Property _definingEnd = end2.getDefiningEnd();
                Class _class_ = _definingEnd.getClass_();
                boolean bl = _notEquals = !Objects.equal((Object)_class_, null);
                if (_notEquals) {
                    Property _definingEnd_1 = end2.getDefiningEnd();
                    String _name_2 = _definingEnd_1.getName();
                    ao1.addPeer(_name_2, ao2);
                }
                boolean bl2 = _notEquals_1 = !Objects.equal((Object)(_class__1 = (_definingEnd_2 = end1.getDefiningEnd()).getClass_()), null);
                if (_notEquals_1) {
                    Property _definingEnd_3 = end1.getDefiningEnd();
                    String _name_3 = _definingEnd_3.getName();
                    ao2.addPeer(_name_3, ao1);
                }
            }
        };
        _ownedConnectors.forEach((Consumer)_function_2);
    }

    public Environment getEnvironment() {
        return this.env;
    }

    public List<Pair<ActiveObject, Transition>> fireableTransitions() {
        Collection<ActiveObject> _values = this.parts.values();
        Functions.Function1<ActiveObject, Set<Pair<ActiveObject, Transition>>> _function = new Functions.Function1<ActiveObject, Set<Pair<ActiveObject, Transition>>>(){

            public Set<Pair<ActiveObject, Transition>> apply(ActiveObject it) {
                return it.fireableTransitions();
            }
        };
        Iterable _map = IterableExtensions.map(_values, (Functions.Function1)_function);
        Iterable _flatten = Iterables.concat((Iterable)_map);
        return IterableExtensions.toList((Iterable)_flatten);
    }

    public ActiveObject getPart(String partName) {
        return this.parts.get(partName);
    }

    public Collection<ActiveObject> getParts() {
        return this.parts.values();
    }

    public String toString() {
        Collection<ActiveObject> _values = this.parts.values();
        Functions.Function1<ActiveObject, String> _function = new Functions.Function1<ActiveObject, String>(){

            public String apply(ActiveObject it) {
                return it.toString();
            }
        };
        Iterable _map = IterableExtensions.map(_values, (Functions.Function1)_function);
        Functions.Function2<String, String, String> _function_1 = new Functions.Function2<String, String, String>(){

            public String apply(String acc, String e) {
                return acc + e + "\n";
            }
        };
        return (String)IterableExtensions.fold((Iterable)_map, (Object)"", (Functions.Function2)_function_1);
    }

    public static boolean isProcess(Type c) {
        boolean _xifexpression = false;
        _xifexpression = c instanceof Class ? ((Class)c).isActive() : false;
        return _xifexpression;
    }

    public static boolean isComponent(Element e) {
        EList _ownedConnectors;
        boolean _isEmpty;
        boolean _xifexpression = false;
        _xifexpression = e instanceof Class ? !(_isEmpty = (_ownedConnectors = ((Class)e).getOwnedConnectors()).isEmpty()) : false;
        return _xifexpression;
    }

    public static boolean isProcessInstance(Property p) {
        boolean _notEquals;
        boolean _and = false;
        boolean _and_1 = false;
        Type _type = p.getType();
        boolean bl = _notEquals = !Objects.equal((Object)_type, null);
        if (!_notEquals) {
            _and_1 = false;
        } else {
            boolean _isProcess;
            Type _type_1 = p.getType();
            _and_1 = _isProcess = Composite.isProcess(_type_1);
        }
        if (!_and_1) {
            _and = false;
        } else {
            boolean _isComponent;
            Element _owner = p.getOwner();
            _and = _isComponent = Composite.isComponent(_owner);
        }
        return _and;
    }

    public Integer getBufferSize() {
        Collection<ActiveObject> _values = this.parts.values();
        Functions.Function2<Integer, ActiveObject, Integer> _function = new Functions.Function2<Integer, ActiveObject, Integer>(){

            public Integer apply(Integer size, ActiveObject ao) {
                int _bufferSize = ao.getBufferSize();
                return size + _bufferSize;
            }
        };
        return (Integer)IterableExtensions.fold(_values, (Object)0, (Functions.Function2)_function);
    }

    public Buffer encode(final ByteBuffer buffer) {
        Buffer _xblockexpression = null;
        Collection<ActiveObject> _values = this.parts.values();
        Consumer<ActiveObject> _function = new Consumer<ActiveObject>(){

            @Override
            public void accept(ActiveObject ao) {
                ao.encode(buffer);
            }
        };
        _values.forEach(_function);
        _xblockexpression = buffer.flip();
        return _xblockexpression;
    }

    public Buffer decode(final ByteBuffer buffer) {
        Buffer _xblockexpression = null;
        Collection<ActiveObject> _values = this.parts.values();
        Consumer<ActiveObject> _function = new Consumer<ActiveObject>(){

            @Override
            public void accept(ActiveObject ao) {
                ao.decode(buffer);
            }
        };
        _values.forEach(_function);
        _xblockexpression = buffer.flip();
        return _xblockexpression;
    }

    public ByteBuffer getCurrentState() {
        Integer _bufferSize = this.getBufferSize();
        ByteBuffer buffer = ByteBuffer.allocate(_bufferSize);
        this.encode(buffer);
        return buffer;
    }

    public <T> T accept(IAbstractVisitor<T> visitor) {
        return visitor.visitComposite(this);
    }

    @Pure
    public Class getC() {
        return this.c;
    }
}

