/*
 * Decompiled with CFR 0.152.
 */
package org.petitparser.grammar.xml;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.petitparser.parser.Parser;
import org.petitparser.parser.primitive.CharacterParser;
import org.petitparser.parser.primitive.StringParser;
import org.petitparser.tools.CompositeParser;

public class XmlGrammar
extends CompositeParser {
    private static final String NAME_START_CHARS = ":A-Z_a-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001\ud7ff\uf900-\ufdcf\ufdf0-\ufffd";
    private static final String NAME_CHARS = "-.0-9\u00b7\u0300-\u036f\u203f-\u2040:A-Z_a-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001\ud7ff\uf900-\ufdcf\ufdf0-\ufffd";

    protected void initialize() {
        this.def("start", this.ref("document").end());
        this.def("attribute", this.ref("qualified").seq(new Parser[]{this.ref("space").optional()}).seq(new Parser[]{CharacterParser.of((char)'=')}).seq(new Parser[]{this.ref("space").optional()}).seq(new Parser[]{this.ref("attributeValue")}).permute(new int[]{0, 4}));
        this.def("attributeValue", this.ref("attributeValueDouble").or(new Parser[]{this.ref("attributeValueSingle")}).pick(1));
        this.def("attributeValueDouble", CharacterParser.of((char)'\"').seq(new Parser[]{CharacterParser.any().starLazy(CharacterParser.of((char)'\"')).flatten()}).seq(new Parser[]{CharacterParser.of((char)'\"')}));
        this.def("attributeValueSingle", CharacterParser.of((char)'\'').seq(new Parser[]{CharacterParser.any().starLazy(CharacterParser.of((char)'\'')).flatten()}).seq(new Parser[]{CharacterParser.of((char)'\'')}));
        this.def("attributes", this.ref("space").seq(new Parser[]{this.ref("attribute")}).pick(1).star());
        this.def("comment", StringParser.of((String)"<!--").seq(new Parser[]{CharacterParser.any().starLazy(StringParser.of((String)"-->")).flatten()}).seq(new Parser[]{StringParser.of((String)"-->")}).pick(1));
        this.def("cdata", StringParser.of((String)"<![CDATA[").seq(new Parser[]{CharacterParser.any().starLazy(StringParser.of((String)"]]>")).flatten()}).seq(new Parser[]{StringParser.of((String)"]]>")}).pick(1));
        this.def("content", this.ref("characterData").or(new Parser[]{this.ref("element")}).or(new Parser[]{this.ref("processing")}).or(new Parser[]{this.ref("comment")}).or(new Parser[]{this.ref("cdata")}).star());
        this.def("doctype", StringParser.of((String)"<!DOCTYPE").seq(new Parser[]{this.ref("space")}).seq(new Parser[]{this.ref("nameToken").or(new Parser[]{this.ref("attributeValue")}).or(new Parser[]{CharacterParser.any().starLazy(CharacterParser.of((char)'[')).seq(new Parser[]{CharacterParser.of((char)'[')}).seq(new Parser[]{CharacterParser.any().starLazy(CharacterParser.of((char)']'))}).seq(new Parser[]{CharacterParser.of((char)']')})}).separatedBy(this.ref("space")).flatten()}).seq(new Parser[]{this.ref("space").optional()}).seq(new Parser[]{CharacterParser.of((char)'>')}).pick(2));
        this.def("document", this.ref("processing").optional().seq(new Parser[]{this.ref("misc")}).seq(new Parser[]{this.ref("doctype").optional()}).seq(new Parser[]{this.ref("misc")}).seq(new Parser[]{this.ref("element")}).seq(new Parser[]{this.ref("misc")}).permute(new int[]{0, 2, 4}));
        this.def("element", CharacterParser.of((char)'<').seq(new Parser[]{this.ref("qualified")}).seq(new Parser[]{this.ref("attributes")}).seq(new Parser[]{this.ref("space").optional()}).seq(new Parser[]{StringParser.of((String)"/>").or(new Parser[]{CharacterParser.of((char)'>').seq(new Parser[]{this.ref("content")}).seq(new Parser[]{StringParser.of((String)"</")}).seq(new Parser[]{this.ref("qualified")}).seq(new Parser[]{this.ref("space").optional()}).seq(new Parser[]{CharacterParser.of((char)'>')})})}).map(new Function<List<?>, List<?>>(){

            @Override
            public List<?> apply(List<?> list) {
                if (list.get(4).equals("/>")) {
                    return Arrays.asList(list.get(1), list.get(2), Collections.emptyList());
                }
                List end = (List)list.get(4);
                if (list.get(1).equals(end.get(3))) {
                    return Arrays.asList(list.get(1), list.get(2), end.get(1));
                }
                throw new IllegalStateException("Expected </" + list.get(1) + ">");
            }
        }));
        this.def("processing", StringParser.of((String)"<?").seq(new Parser[]{this.ref("nameToken")}).seq(new Parser[]{this.ref("space").seq(new Parser[]{CharacterParser.any().starLazy(StringParser.of((String)"?>")).flatten()}).pick(1).optional((Object)"")}).seq(new Parser[]{StringParser.of((String)"?>")}).permute(new int[]{1, 2}));
        this.def("qualified", this.ref("nameToken"));
        this.def("characterData", CharacterParser.pattern((String)"^<").plus().flatten());
        this.def("misc", this.ref("space").or(new Parser[]{this.ref("comment")}).or(new Parser[]{this.ref("processing")}).star());
        this.def("space", CharacterParser.whitespace().plus());
        this.def("nameToken", this.ref("nameStartChar").seq(new Parser[]{this.ref("nameChar").star()}).flatten());
        this.def("nameStartChar", CharacterParser.pattern((String)NAME_START_CHARS, (String)"Expected name"));
        this.def("nameChar", CharacterParser.pattern((String)NAME_CHARS));
    }
}

