/*
 * Decompiled with CFR 0.152.
 */
package plug.language.remote.runtime;

import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import plug.core.IAtomicPropositionsEvaluator;
import plug.core.IFiredTransition;
import plug.core.ITransitionRelation;
import plug.language.remote.driver.TCPDriver;
import plug.language.remote.runtime.Configuration;
import plug.language.remote.runtime.FireableTransition;
import plug.language.remote.runtime.RemoteAtomicPropositionsEvaluator;
import plug.statespace.transitions.FiredTransition;

public class RemoteRuntime
implements ITransitionRelation<Configuration, FireableTransition> {
    protected final TCPDriver driver;
    protected final RemoteAtomicPropositionsEvaluator atomicPropositionsEvaluator;

    public RemoteRuntime(String address, int port) {
        this.driver = new TCPDriver(address, port);
        this.atomicPropositionsEvaluator = new RemoteAtomicPropositionsEvaluator(this.driver);
    }

    public TCPDriver getDriver() {
        return this.driver;
    }

    public void initializeRuntime() throws IOException {
        this.driver.connect();
    }

    public synchronized Set<Configuration> initialConfigurations() {
        return this.driver.initialConfigurations();
    }

    public synchronized Collection<FireableTransition> fireableTransitionsFrom(Configuration configuration) {
        return this.driver.fireableTransitionsFrom(configuration);
    }

    public synchronized IFiredTransition<Configuration, ?> fireOneTransition(Configuration source, FireableTransition transition) {
        Collection<Configuration> target = this.driver.fireOneTransition(source, transition);
        return new FiredTransition((Object)source, target, (Object)transition);
    }

    public IAtomicPropositionsEvaluator getAtomicPropositionEvaluator() {
        return this.atomicPropositionsEvaluator;
    }

    public void close() {
        this.driver.disconnect();
    }
}

