/*
 * Decompiled with CFR 0.152.
 */
package spinja.promela.compiler.actions;

import java.util.ArrayList;
import java.util.Collection;
import spinja.promela.compiler.Proctype;
import spinja.promela.compiler.actions.Action;
import spinja.promela.compiler.expression.Expression;
import spinja.promela.compiler.expression.Identifier;
import spinja.promela.compiler.parser.ParseException;
import spinja.promela.compiler.parser.Token;
import spinja.promela.compiler.variable.VariableAccess;
import spinja.util.StringWriter;

public class AssignAction
extends Action {
    private final Identifier id;
    private final Expression expr;

    public AssignAction(Token token, Identifier identifier) {
        this(token, identifier, null);
    }

    public AssignAction(Token token, Identifier identifier, Expression expression) {
        super(token);
        this.id = identifier;
        this.expr = expression;
        if (expression != null) {
            for (VariableAccess variableAccess : expression.readVariables()) {
                variableAccess.getVar().setRead(true);
            }
        }
        identifier.getVariable().setWritten(true);
        if (this.getToken().kind == 86 || this.getToken().kind == 87) {
            identifier.getVariable().setRead(true);
        }
    }

    @Override
    public String getEnabledExpression() {
        return null;
    }

    public Expression getExpr() {
        return this.expr;
    }

    @Override
    public boolean isLocal(Proctype proctype) {
        if (this.expr != null) {
            for (VariableAccess variableAccess : this.expr.readVariables()) {
                if (proctype.hasVariable(variableAccess.getVar().getName())) continue;
                return false;
            }
        }
        return proctype.hasVariable(this.id.getVariable().getName()) && super.isLocal(proctype);
    }

    @Override
    public Collection<Identifier> getChangedVariables() {
        ArrayList<Identifier> arrayList = new ArrayList<Identifier>(1);
        arrayList.add(this.id);
        return arrayList;
    }

    @Override
    public void printTakeStatement(StringWriter stringWriter) throws ParseException {
        String string = this.id.getVariable().getType().getMask();
        switch (this.getToken().kind) {
            case 52: {
                try {
                    int n = this.expr.getConstantValue();
                    stringWriter.appendLine(this.id.getIntExpression(), " = ", n & this.id.getVariable().getType().getMaskInt(), ";");
                }
                catch (ParseException parseException) {
                    stringWriter.appendLine(this.id.getIntExpression(), " = ", this.expr.getIntExpression(), string == null ? "" : " & " + string, ";");
                }
                break;
            }
            case 86: {
                if (string == null) {
                    stringWriter.appendLine(this.id.getIntExpression(), "++;");
                    break;
                }
                stringWriter.appendLine(this.id.getIntExpression(), " = (", this.id.getIntExpression(), " + 1) & ", string, ";");
                break;
            }
            case 87: {
                if (string == null) {
                    stringWriter.appendLine(this.id.getIntExpression(), "--;");
                    break;
                }
                stringWriter.appendLine(this.id.getIntExpression(), " = (", this.id.getIntExpression(), " - 1) & ", string, ";");
                break;
            }
            default: {
                throw new ParseException("unknown assignment type");
            }
        }
    }

    @Override
    public void printUndoStatement(StringWriter stringWriter) throws ParseException {
        switch (this.getToken().kind) {
            case 52: {
                if (this.expr.getSideEffect() != null) {
                    stringWriter.appendLine("endProcess();");
                }
            }
            case 86: 
            case 87: {
                break;
            }
            default: {
                throw new ParseException("unknown assignment type");
            }
        }
    }

    @Override
    public String toString() {
        switch (this.getToken().kind) {
            case 52: {
                return this.id.toString() + "=" + this.expr.toString();
            }
            case 86: {
                return this.id.toString() + "++";
            }
            case 87: {
                return this.id.toString() + "--";
            }
        }
        return "unknown assignment type";
    }
}

