/*
 * Decompiled with CFR 0.152.
 */
package spinja.options;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import spinja.util.StringWriter;

public abstract class Option
implements Comparable<Option> {
    private final char letter;
    protected static final int TABPOS = 24;
    private final String description;

    public Option(char c, String string) {
        this.letter = c;
        this.description = string;
    }

    @Override
    public int compareTo(Option option) {
        return this.getChar() - option.getChar();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Option)) {
            return false;
        }
        return this.getChar() == ((Option)object).getChar();
    }

    public final char getChar() {
        return this.letter;
    }

    public final String getDescription() {
        return this.description;
    }

    public abstract boolean isSet();

    public abstract void parseOption(String var1);

    public String toString() {
        return this.toString("");
    }

    public String toString(String string) {
        StringWriter stringWriter = new StringWriter();
        stringWriter.append("   -").append(Character.valueOf(this.getChar())).append(string);
        stringWriter.append(this.indentedDescription(24 - stringWriter.length(), this.getDescription()));
        return stringWriter.toString();
    }

    protected String indentedDescription(int n, String string) {
        StringWriter stringWriter = new StringWriter();
        while (stringWriter.length() < n) {
            stringWriter.append(Character.valueOf(' '));
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                stringWriter.append(string2);
                string2 = bufferedReader.readLine();
                if (string2 == null) continue;
                stringWriter.append("\n");
                for (int i = 0; i < 24; ++i) {
                    stringWriter.append(Character.valueOf(' '));
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return stringWriter.toString();
    }
}

