/*
 * Decompiled with CFR 0.152.
 */
package spinja.model;

import spinja.model.Transition;
import spinja.model.listener.PrintEvent;
import spinja.model.listener.PrintListener;
import spinja.model.listener.TransitionEvent;
import spinja.model.listener.TransitionListener;

public abstract class ObservableModel {
    private PrintListener[] printListeners = null;
    private boolean printListenerActive = true;
    private TransitionListener[] transitionListeners = null;
    private boolean transitionListenerActive = true;

    public void activatePrintListener(boolean bl) {
        this.printListenerActive = bl;
    }

    public void activateTransitionListener(boolean bl) {
        this.transitionListenerActive = bl;
    }

    public void addPrintListener(PrintListener printListener) {
        if (this.printListeners == null) {
            this.printListeners = new PrintListener[]{printListener};
        } else {
            PrintListener[] printListenerArray = new PrintListener[this.printListeners.length + 1];
            System.arraycopy(this.printListeners, 0, printListenerArray, 0, this.printListeners.length);
            printListenerArray[this.printListeners.length] = printListener;
            this.printListeners = printListenerArray;
        }
    }

    public void addTransitionListener(TransitionListener transitionListener) {
        if (this.transitionListeners == null) {
            this.transitionListeners = new TransitionListener[]{transitionListener};
        } else {
            TransitionListener[] transitionListenerArray = new TransitionListener[this.transitionListeners.length + 1];
            System.arraycopy(this.transitionListeners, 0, transitionListenerArray, 0, this.transitionListeners.length);
            transitionListenerArray[this.transitionListeners.length] = transitionListener;
            this.transitionListeners = transitionListenerArray;
        }
    }

    public void sendPrintEvent(String string) {
        if (this.printListenerActive && this.printListeners != null) {
            PrintEvent printEvent = new PrintEvent(string);
            for (PrintListener printListener : this.printListeners) {
                printListener.print(printEvent);
            }
        }
    }

    public void sendTransitionTakenEvent(Transition transition) {
        if (this.transitionListenerActive && this.transitionListeners != null) {
            TransitionEvent transitionEvent = new TransitionEvent(transition);
            for (TransitionListener transitionListener : this.transitionListeners) {
                transitionListener.transitionTaken(transitionEvent);
            }
        }
    }

    public void sendTransitionUndoEvent(Transition transition) {
        if (this.transitionListenerActive && this.transitionListeners != null) {
            TransitionEvent transitionEvent = new TransitionEvent(transition);
            for (TransitionListener transitionListener : this.transitionListeners) {
                transitionListener.transitionUndo(transitionEvent);
            }
        }
    }
}

