/*
 * Decompiled with CFR 0.152.
 */
package obp.ui.ifx;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import obp.ui.ifx.IFxConfigurationController;
import obp.ui.ifx.IFxUI;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.FileDialog;
import org.xid.basics.Basics;
import org.xid.basics.progress.ActionMonitor;
import org.xid.basics.ui.action.Action;
import org.xid.basics.ui.controller.Controller;
import org.xid.basics.ui.dialog.FieldDialog;

public class Actions {
    private IFxUI ifxUI;
    private Action separatorAction;
    private Action menuAction;
    private Action fileAction;
    private Action openSystemAction;
    private Action openObserverAction;
    private Action removeObserverAction;
    private Action preferencesAction;
    private Action quitAction;
    private Action systemAction;
    private Action exploreSystemAction;
    private Action cleanAction;
    private Action stopAction;
    private Action viewAction;
    private Action printVersionAction;
    private Action clearConsoleAction;

    public Actions(IFxUI ifxUI) {
        this.ifxUI = ifxUI;
    }

    public Action getSeparatorAction() {
        if (this.separatorAction == null) {
            this.separatorAction = new Action.Stub(27);
        }
        return this.separatorAction;
    }

    public Action getMenuAction() {
        if (this.menuAction == null) {
            this.menuAction = new Action.Container("Menu", new Action[]{this.getFileAction(), this.getSystemAction(), this.getViewAction()});
        }
        return this.menuAction;
    }

    public Action getFileAction() {
        if (this.fileAction == null) {
            this.fileAction = Basics.isMac() ? new Action.Container("File", new Action[]{this.getOpenSystemAction(), this.getSeparatorAction(), this.getOpenObserverAction(), this.getRemoveObserverAction()}) : new Action.Container("File", new Action[]{this.getOpenSystemAction(), this.getSeparatorAction(), this.getOpenObserverAction(), this.getRemoveObserverAction(), this.getSeparatorAction(), this.getPreferencesAction(), this.getSeparatorAction(), this.getQuitAction()});
        }
        return this.fileAction;
    }

    public Action getOpenSystemAction() {
        if (this.openSystemAction == null) {
            this.openSystemAction = new Action.Stub("Open System\u2026", this.getImage("eclipse/open_edit.gif")){

                public int run(ActionMonitor monitor) {
                    FileDialog dialog = new FileDialog(Actions.this.ifxUI.getShell(), 4096);
                    dialog.setFilterNames(new String[]{"IF System"});
                    dialog.setFilterExtensions(new String[]{"*.if"});
                    String filename = dialog.open();
                    if (filename == null) {
                        return 2;
                    }
                    File file = new File(filename);
                    if (!file.exists() || !file.canRead()) {
                        return 3;
                    }
                    Actions.this.ifxUI.setSystemFile(file);
                    Actions.this.ifxUI.log("IF file '" + file.getPath() + "' loaded.\n");
                    return 1;
                }
            };
        }
        return this.openSystemAction;
    }

    public Action getOpenObserverAction() {
        if (this.openObserverAction == null) {
            this.openObserverAction = new Action.Stub("Open Observer\u2026", this.getImage("eclipse/open_edit.gif")){

                public int run(ActionMonitor monitor) {
                    FileDialog dialog = new FileDialog(Actions.this.ifxUI.getShell(), 4096);
                    dialog.setFilterNames(new String[]{"IF Observer"});
                    dialog.setFilterExtensions(new String[]{"*.oif"});
                    String filename = dialog.open();
                    if (filename == null) {
                        return 2;
                    }
                    File file = new File(filename);
                    if (!file.exists() || !file.canRead()) {
                        return 3;
                    }
                    Actions.this.ifxUI.addObserverFile(file);
                    Actions.this.ifxUI.selectObserver(file);
                    Actions.this.ifxUI.log("IF observer file '" + file.getPath() + "' loaded.\n");
                    return 1;
                }
            };
        }
        return this.openObserverAction;
    }

    public Action getRemoveObserverAction() {
        if (this.removeObserverAction == null) {
            this.removeObserverAction = new Action.Stub("Remove Observer", this.getImage("eclipse/delete_edit.gif")){

                public int getVisibility() {
                    return Actions.this.ifxUI.getSelectedObserver() == null ? 2 : 1;
                }

                public int run(ActionMonitor monitor) {
                    File file = Actions.this.ifxUI.getSelectedObserver();
                    Actions.this.ifxUI.removeObserverFile(file);
                    Actions.this.ifxUI.log("IF observer file '" + file.getPath() + "' removed.\n");
                    return 1;
                }
            };
        }
        return this.removeObserverAction;
    }

    public Action getPreferencesAction() {
        if (this.preferencesAction == null) {
            this.preferencesAction = new Action.Stub("Preferences"){

                public int run(ActionMonitor monitor) {
                    IFxConfigurationController configurationController = new IFxConfigurationController(Actions.this.ifxUI.getShell());
                    configurationController.setSubject(Actions.this.ifxUI.getIfxConfiguration());
                    FieldDialog dialog = new FieldDialog(Actions.this.ifxUI.getShell(), "IFxUI", "IFx Configuration", 6, (Controller)configurationController);
                    dialog.setButtonLabel(new String[]{"Ok"});
                    dialog.open();
                    return 1;
                }
            };
        }
        return this.preferencesAction;
    }

    public Action getQuitAction() {
        if (this.quitAction == null) {
            this.quitAction = new Action.Stub("Quit IFxUI"){

                public int run(ActionMonitor monitor) {
                    Actions.this.ifxUI.getShell().dispose();
                    return 1;
                }
            };
        }
        return this.quitAction;
    }

    public Action getSystemAction() {
        if (this.systemAction == null) {
            this.systemAction = new Action.Container("System", new Action[]{this.getExploreSystemAction(), this.getCleanAction(), this.getSeparatorAction(), this.getStopAction()});
        }
        return this.systemAction;
    }

    public Action getExploreSystemAction() {
        if (this.exploreSystemAction == null) {
            this.exploreSystemAction = new Action.Stub("Explore"){

                public int getVisibility() {
                    return Actions.this.ifxUI.canExplore() ? 1 : 2;
                }

                public int run(ActionMonitor monitor) {
                    Actions.this.ifxUI.explore();
                    return 1;
                }
            };
        }
        return this.exploreSystemAction;
    }

    public Action getCleanAction() {
        if (this.cleanAction == null) {
            this.cleanAction = new Action.Stub("Clean"){

                public int getVisibility() {
                    return Actions.this.ifxUI.canClean() ? 1 : 2;
                }

                public int run(ActionMonitor monitor) {
                    Actions.this.ifxUI.clean();
                    return 1;
                }
            };
        }
        return this.cleanAction;
    }

    public Action getStopAction() {
        if (this.stopAction == null) {
            this.stopAction = new Action.Stub("Stop"){

                public int getVisibility() {
                    return Actions.this.ifxUI.isWorking() ? 1 : 2;
                }

                public int run(ActionMonitor monitor) {
                    Actions.this.ifxUI.stopCurrentAction();
                    return 1;
                }
            };
        }
        return this.stopAction;
    }

    public Action getViewAction() {
        if (this.viewAction == null) {
            this.viewAction = new Action.Container("View", new Action[]{this.getClearConsoleAction(), this.getPrintVersionAction()});
        }
        return this.viewAction;
    }

    public Action getPrintVersionAction() {
        if (this.printVersionAction == null) {
            this.printVersionAction = new Action.Stub("Print Version"){

                public int run(ActionMonitor monitor) {
                    Actions.this.ifxUI.printVersion();
                    return 1;
                }
            };
        }
        return this.printVersionAction;
    }

    public Action getClearConsoleAction() {
        if (this.clearConsoleAction == null) {
            this.clearConsoleAction = new Action.Stub("Clear console", 10){

                public int run(ActionMonitor monitor) {
                    Actions.this.ifxUI.clearConsole();
                    return 1;
                }
            };
        }
        return this.clearConsoleAction;
    }

    public Image getImage(String filename) {
        return this.ifxUI.getResources().getImage(filename);
    }

    public static String loadContents(File file) {
        StringBuilder contents = new StringBuilder();
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            byte[] buffer = new byte[1024];
            int read = in.read(buffer);
            while (read >= 0) {
                contents.append(new String(buffer, 0, read));
                read = in.read(buffer);
            }
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return contents.toString();
    }
}

