/*
 * Decompiled with CFR 0.152.
 */
package obp.ui.cdl.diagram;

import obp.cdl.Activity;
import obp.cdl.AltActivity;
import obp.ui.cdl.diagram.ActivityElement;
import obp.ui.cdl.diagram.CDLDiagram;
import org.xid.basics.geometry.Geometry;
import org.xid.basics.ui.diagram.DiagramContext;
import org.xid.basics.ui.diagram.gc.GC;
import org.xid.basics.ui.diagram.gc.GcUtils;

public class AltActivityElement
extends ActivityElement {
    private final AltActivity model;
    private final int occurences;

    public AltActivityElement(AltActivity model, int occurences, boolean rejoin, float[] northPoint) {
        super(rejoin, northPoint);
        this.model = model;
        this.occurences = occurences;
    }

    @Override
    public void buildChildren(CDLDiagram diagram) {
        float[] refPoint = Geometry.copyPoints((float[])this.northPoint);
        refPoint[1] = refPoint[1] + 50.0f;
        for (int i = 0; i < this.model.getActivityCount(); ++i) {
            boolean last;
            Activity child = this.model.getActivity(i);
            ActivityElement element = AltActivityElement.createElement(diagram, child, (last = i == this.model.getActivityCount() - 1) || this.rejoin, refPoint);
            if (element == null) continue;
            this.children.add(element);
            this.size[0] = this.size[0] + element.size[0];
            this.size[1] = Math.max(this.size[1], element.size[1]);
            refPoint[0] = refPoint[0] + (element.size[0] + 50.0f);
        }
        if (this.children.size() > 1) {
            this.size[0] = this.size[0] + (float)(this.children.size() - 1) * 50.0f;
        }
        this.size[1] = this.size[1] + 100.0f;
        float dx = -this.size[0] / 2.0f;
        float dy = this.size[1] / 2.0f;
        for (ActivityElement child : this.children) {
            child.moveNorthPoint(dx + child.size[0] / 2.0f, dy - child.size[1] / 2.0f - 50.0f);
        }
    }

    @Override
    public void moveNorthPoint(float dx, float dy) {
        super.moveNorthPoint(dx, dy);
        for (ActivityElement child : this.children) {
            child.moveNorthPoint(dx, dy);
        }
    }

    @Override
    public void display(GC gc, DiagramContext context) {
        gc.setBackground(context.getResources().getSystemColor(2));
        float[] tmpRectangle = Geometry.rectangleAlignedOn((float)10.0f, (float)5.0f, (float)this.northPoint[0], (float)(this.northPoint[1] - 2.5f), (int)-1);
        GcUtils.drawTriangle((GC)gc, (float[])tmpRectangle, (int)6, (boolean)true);
        Geometry.translatePointsBy((float[])tmpRectangle, (float)0.0f, (float)5.0f);
        GcUtils.drawTriangle((GC)gc, (float[])tmpRectangle, (int)2, (boolean)true);
        gc.setBackground(context.getDiagram().getBackground(context));
        for (ActivityElement child : this.children) {
            GcUtils.drawLine((GC)gc, (float[])this.northPoint, (float[])child.northPoint);
            if (this.rejoin) {
                GcUtils.drawLine((GC)gc, (float[])this.getSouthPoint(), (float[])child.getSouthPoint());
            }
            context.getDiagram().resetGc(gc, context);
            child.display(gc, context);
            context.getDiagram().resetGc(gc, context);
            if (child instanceof AltActivityElement || this.rejoin) continue;
            gc.setBackground(context.getResources().getSystemColor(2));
            gc.fillOval((int)child.northPoint[0] - 5, (int)(child.northPoint[1] + child.size[1]) - 5, 10, 10);
        }
        if (this.rejoin) {
            gc.setBackground(context.getResources().getSystemColor(2));
            tmpRectangle = Geometry.rectangleAlignedOn((float)10.0f, (float)5.0f, (float)this.northPoint[0], (float)(this.northPoint[1] + this.size[1] - 2.5f), (int)-1);
            GcUtils.drawTriangle((GC)gc, (float[])tmpRectangle, (int)6, (boolean)true);
            Geometry.translatePointsBy((float[])tmpRectangle, (float)0.0f, (float)5.0f);
            GcUtils.drawTriangle((GC)gc, (float[])tmpRectangle, (int)2, (boolean)true);
        }
        if (this.occurences > 1) {
            this.displayFrame(gc, context, null, this.occurences);
        }
        super.display(gc, context);
    }

    @Override
    public AltActivity getModel() {
        return this.model;
    }
}

