/*
 * Decompiled with CFR 0.152.
 */
package obp.states;

import obp.states.Element;
import obp.states.Message;
import obp.states.PID;
import obp.states.State;
import obp.states.StatesVisitor;
import obp.states.Variable;

public class Process
extends Element {
    protected Variable[] variableList;
    protected Variable[] parameterList;
    protected PID pid;
    protected Message[] messageList;
    protected String currentState;
    protected State parent;

    protected Process() {
        this(null, null, null, null, null);
    }

    public Process(PID pid, String currentState, Variable[] variableList, Variable[] parameterList, Message[] messageList) {
        this.pid = pid;
        this.currentState = currentState;
        this.variableList = variableList;
        this.parameterList = parameterList;
        this.messageList = messageList;
    }

    public Variable[] getVariableList() {
        return this.variableList;
    }

    public int getVariableCount() {
        return this.variableList.length;
    }

    public Variable[] getParameterList() {
        return this.parameterList;
    }

    public int getParameterCount() {
        return this.parameterList.length;
    }

    public PID getPid() {
        return this.pid;
    }

    public Message[] getMessageList() {
        return this.messageList;
    }

    public int getMessageCount() {
        return this.messageList.length;
    }

    public String getCurrentState() {
        return this.currentState;
    }

    public State getParent() {
        return this.parent;
    }

    @Override
    public void accept(StatesVisitor visitor) {
        visitor.visit(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.currentState == null ? 0 : this.currentState.hashCode());
        result = 31 * result + (this.messageList == null ? 0 : this.messageList.hashCode());
        result = 31 * result + (this.parameterList == null ? 0 : this.parameterList.hashCode());
        result = 31 * result + (this.pid == null ? 0 : this.pid.hashCode());
        result = 31 * result + (this.variableList == null ? 0 : this.variableList.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Process other = (Process)obj;
        if (this.currentState == null ? other.currentState != null : !this.currentState.equals(other.currentState)) {
            return false;
        }
        if (this.messageList == null ? other.messageList != null : !this.messageList.equals(other.messageList)) {
            return false;
        }
        if (this.parameterList == null ? other.parameterList != null : !this.parameterList.equals(other.parameterList)) {
            return false;
        }
        if (this.pid == null ? other.pid != null : !this.pid.equals(other.pid)) {
            return false;
        }
        return !(this.variableList == null ? other.variableList != null : !this.variableList.equals(other.variableList));
    }
}

